#ifndef OPENGLWND_H
#define OPENGLWND_H

#include "stdafx.h"


class CMessageProc;

class OpenGLWnd 
{

private:
	CMessageProc   *m_pcMsgProcessor;

	bool			m_bRunning;						// Ar programa aktyvi ?
	
	float			m_fCurFPS;
private:
	friend int FrameWorkInit( OpenGLWnd   *_pcApp,
							  HINSTANCE	hInstance,			
							  HINSTANCE	hPrevInstance,		
							  LPSTR		lpCmdLine,			
							  int			nCmdShow);		
	friend LRESULT CALLBACK WndProc(HWND	hWnd,			
									UINT	uMsg,			
									WPARAM	wParam,			
									LPARAM	lParam)	;
	void	DrawGLScene();
	void	Loop();
public:
	OpenGLWnd (CMessageProc *pcMsgProc);
	virtual ~OpenGLWnd();
	
	//Basic Window Creation
	BOOL	CreateGLWindow(const char* title, int width, int height, int bits,bool _bFullScreen,HINSTANCE hInstance,
						   WNDPROC fnWndProc);					   
	void	DestroyGLWindow();
	void	ReSizeGLScene();
	//OpenGL initialization
	bool	InitExtensions();
	virtual bool	InitGL();
	virtual void	DeInitGL();	
	//Managers
	virtual bool	InitManagers();
	virtual void	DeInitManagers();
	//Resources
	virtual bool	LoadResources();
	virtual void	UnLoadResources();	
	//Settings
	virtual void	LoadSettings();
	virtual void	SaveSettings();

	//Rendering
	virtual void	PreRender();
	virtual void	RenderStaticScene();					//Static objects (houses,terrain,etc)
	virtual void	RenderDynamicScene();					//Dynamic scene 
	virtual void	PostRender();
	//CheckInput
	virtual void	CheckInput();
	//Update
	virtual void	Update(float nDeltaTime);

	//Menu Process
	virtual void	SetMenuValues();
	virtual bool	ProcessMenu(int wmId ,int wmEvent);
	
	
	bool	IfRunning(){return m_bRunning;}
	void	End()	   {m_bRunning=false;}
	
	float	GetFPS()   {return m_fCurFPS;}
	

};

#endif