#ifndef CFRAMEBUFFERMANAGER_HPP
#define CFRAMEBUFFERMANAGER_HPP

#include "Managers/CManager.hpp"

class CFbo
{
	friend class CFrameBufferManager;
private:
	unsigned int m_nFrameBuffer;
	unsigned int m_nColorTex;
	unsigned int m_nDepthBuffer;
	unsigned int m_nSizeX,m_nSizeY;
public:
	CFbo(unsigned int nSizeX,unsigned int nSizeY);
	~CFbo();
	
	unsigned int GetSizeX(){return m_nSizeX;}
	unsigned int GetSizeY(){return m_nSizeY;}

};


class CFrameBufferManager:public CManager<CFbo*>
{

public:
	CFrameBufferManager();
	~CFrameBufferManager();
	
	CFbo*		CreateFrameBufferObject(const char *strName,unsigned int nSizeX,unsigned int nSizeY);
	CFbo*		GetFrameBufferObject(const char *strName);
	
	//If you pass NULL, you'll switch to default FrameBuffer
	void		SwitchToFbo		   (CFbo * pcFbo = NULL);
	void		BindFboColorTexture(CFbo * pcFbo);
public:
	static		void	IsSupported();
	static		void	CheckFboError();
};


extern CFrameBufferManager	*g_pcFboMan;

#endif