#ifndef CMANAGER_HPP
#define CMANAGER_HPP

#include "Types/Hash.hpp"
#include "Utils/MiscFuncs.hpp"



template <class ItemData>class CManager 
{
protected:
    char			*m_strCurDir;
    MapHash<ItemData>	m_cItems;
public:
	CManager()
	{
		m_strCurDir=NULL;
		strAllocNCopy(&m_strCurDir,"Data\\"); 
	}
	virtual ~CManager()
	{
		if(m_strCurDir)
		{
			strFree(&m_strCurDir);
		}
	}

	void AddItem(const char *strName,ItemData pcItem)
	{
		m_cItems.Add(strName,pcItem);
	}
	bool FindItem(const char *strName,ItemData& pcItem)
	{
		HashItem<ItemData> *pcHashItem=m_cItems.Find(strName);
		if(pcHashItem)
		{
			pcItem=pcHashItem->data;
			return true;
		}
		else
		{
			return false;
		}
	}
	bool		NameExists(const char *strName)
	{
		return m_cItems.Find(strName)!=NULL;
	}
	void		SetDir(const char *_strDir)
	{
		strAllocNCopy(&m_strCurDir,_strDir); 
	}
	const char *GetDir()
	{
		return m_strCurDir;
	}
	
	//Gets filename and homeDir as input and generates full path
	//HomeDir+CurDir+FileName
	void GetFullPath(const char *strHomeDir,const char *strFileName,char *strResult)
	{
		strResult[0]='\0';
		if(strHomeDir[0]!='\0')
			strcat_s(strResult,1024,strHomeDir);
		if(m_strCurDir[0]!='\0')
			strcat_s(strResult,1024,m_strCurDir);
		if(strFileName[0]!='\0')
			strcat_s(strResult,1024,strFileName);
	}

};

#endif //__CMANAGER_HPP__
