#ifndef CMATERIALMANAGER_HPP
#define CMATERIALMANAGER_HPP

#include "Managers/CManager.hpp"
#include "Materials/CMaterial.hpp"

class CMaterialManager:public CManager<CMaterial*>
{
private:
	CMaterial * m_pcDefaultMat;
	char		m_strMatName[1024];
public:
	CMaterialManager();
	~CMaterialManager();

	void		InitMaterials();
	
	void		AddCustomMaterial(CMaterial *pcMaterial);

	CMaterial  *LoadTctMaterial  (const char *strMatName);
	
	CMaterial  *GetMaterial      (const char *strMatName);
	
	CMaterial  *GetDefaultMat();
private:
	bool		bStorageOpened;
	FILE	   *fStorageFile[2];



	//These functions are required for building shaders in memory
	void		StartBuildShaderStorage();
	void		AppendShader(bool bVSorFS,const char *strShFName);
	void		EndBuild();

};

extern CMaterialManager *g_pcMatMan;

#endif