#ifndef		CTEXTUREMANAGER_H
#define		CTEXTUREMANAGER_H

#include	"Texture/CTexture.h"
#include    "Managers/CManager.hpp"


class CTexName
{
public:
	char strName[255];

	CTexName()
	{
	}
	CTexName(char *_Name)
	{
		strcpy(strName,_Name);
	}
	void SetName(char *_Name)
	{
		strcpy(strName,_Name);
	}
};


// ==============================================
// CTextureManager - OpenGL texture manager.
// ==============================================

class CTextureManager : public CManager<CTexture*>
{
private:
	char				m_strFullPath[1024];

	CTexture			*m_pcDefaultTex2D;	

	unsigned int		m_iTextureCount;	
	
	
private:
	//For Texture 2D
	bool	CreateDefaultTexture2D( unsigned int size );
	void	CreateGLTexture( CTexture *img );
	bool	LoadTextureFromFile(const char *szFileName, CTexture **img, bool bFlipVert,bool bForceRGBA = false );
public:
	CTextureManager();
	~CTextureManager();
	bool				Init();
	//Release all textures
	void				ReleaseTextures();
	//Loading Textures
	CTexture*			CreateTexture(const char *szFileName,
									  int nWidth,int nLength,
									  int channels=4,
									  int type=GL_RGBA);
	CTexture*			LoadTexture2D(const char *szFileName,
									  bool bFlipVert = false,
									  bool bForceRGBA= false);
	CTexture*			LoadTexture3D(int nWidth, 
									  int nLength,
									  int nHeight,
									  CTexName *pcFileName);
	CTexture*			LoadCubeMap  (const char *szFileName,
									  const char *srtExtension = ".bmp");
	CTexture*			LoadNoiseTexture(const char *szFileName,
										 bool bFlipVert = false );
	
	//Misc Functions
	CTexture			*GetTexture(const char *szFileName );
	CTexture			*GetDefaultTexture()
	{
		return m_pcDefaultTex2D;
	}
	
	inline GLuint CTextureManager::GetTextureID(const char *szFileName )
	{
		return GetTexture( szFileName )->GetTextureId();
	}
	
	inline unsigned int GetTextureCount() const
	{
		return m_iTextureCount;
	}
	inline bool IsDefaultTexture(const CTexture *img )
	{
		return img->m_nTextureId == m_pcDefaultTex2D->m_nTextureId;
	}




private:





};



extern CTextureManager *g_pcTexMan;

#endif	// __TEXTURE_H
