#ifndef CTCTATTRIBUTES_HPP
#define CTCTATTRIBUTES_HPP

#include "Types/Vector2D.h"
#include "Types/Vector3D.h"
#include "Types/Vector4D.h"

class CShaderObject;

class CTctAttribute
{
protected:
	char *m_strName;
public:
	CTctAttribute(const char *strName);
	virtual ~CTctAttribute();

	virtual void SetAttribute(CShaderObject *pcShader) = 0;
};

class CTctAttrFloat:public CTctAttribute
{
	float m_fValue;
public:
	CTctAttrFloat(const char *strName,float fValue);
	void SetAttribute(CShaderObject *pcShader);
};

class CTctAttrInt:public CTctAttribute
{
	int m_nValue;
public:
	CTctAttrInt(const char *strName,int nValue);
	void SetAttribute(CShaderObject *pcShader);
};

class CTctAttrVec2:public CTctAttribute
{
	Vector2D m_vValue;
public:
	CTctAttrVec2(const char *strName,Vector2D vValue);
	void SetAttribute(CShaderObject *pcShader);
};

class CTctAttrVec3:public CTctAttribute
{
	Vector3D m_vValue;
public:
	CTctAttrVec3(const char *strName,Vector3D vValue);
	void SetAttribute(CShaderObject *pcShader);
};

class CTctAttrVec4:public CTctAttribute
{
	Vector4D m_vValue;
public:
	CTctAttrVec4(const char *strName,Vector4D vValue);
	void SetAttribute(CShaderObject *pcShader);
};

class CTctAttrFloatPtr:public CTctAttribute
{
	float *m_pfValue;
public:
	CTctAttrFloatPtr(const char *strName,float *pfValue);
	void SetAttribute(CShaderObject *pcShader);
};

class CTctAttrIntPtr:public CTctAttribute
{
	int *m_pnValue;
public:
	CTctAttrIntPtr(const char *strName,int *pnValue);
	void SetAttribute(CShaderObject *pcShader);
};

class CTctAttrVec3Ptr:public CTctAttribute
{
	Vector3D *m_pvValue;
public:
	CTctAttrVec3Ptr(const char *strName,Vector3D *pvValue);
	void SetAttribute(CShaderObject *pcShader);
};


#endif