#ifndef CTCTMAT_HPP
#define CTCTMAT_HPP

#include "Materials/CMaterial.hpp"
#include "stdafx.h"
#include "Types/Vector2D.h"
#include "Types/Vector3D.h"
#include "Types/Vector4D.h"
#include "Types/LinkedList.hpp"

class TiXmlNode;
class TiXmlAttribute;
class CTexture;
class CTctAttribute;

class CTctMap
{

	CTexture	   *m_pcTexture;
	char		   *m_strMapName;
	float			m_fMapAmount;
	Vector2D		m_vUVOffset;
	Vector2D		m_vUVTiling;
	float			m_fUVAngle;
	float			m_fUVBlur;
	float			m_fUVBlurOffset;
	float			m_fNoiseAmt;
	float			m_fNoiseSize;
	int				m_nNoiseLvl;
	float			m_fNoisePhase;
	
	bool			m_bEnabled;
	
	int				m_nTextureLevel;		//Used for shader multitexture
											//For ex., suppose we have Diffuse and Bump
											//Diffuse level will be 0, and Bump - 1 (not 8)
public:
	CTctMap(const char *strName = "Diffuse");
	~CTctMap();
	
	inline	bool	 IfEnabled()const	 {	return m_bEnabled;}
	inline	void	 Enable(bool _bEnable){m_bEnabled=_bEnable;}
	
	inline	void	 SetTexture(CTexture *pcTexture){m_pcTexture=pcTexture;}
	inline  CTexture*GetTexture()const	 {return m_pcTexture;}
	
	inline	void	 SetTexLvl(int _nTexLvl){m_nTextureLevel=_nTexLvl;}
	inline  GLuint	 GetTexLvl()const	 {return m_nTextureLevel;}
	
	inline	void	 SetMapAmount(float _fMapAmount){m_fMapAmount=_fMapAmount;}
	inline	float	 GetMapAmount()const {return m_fMapAmount;}
	
	inline	void	 SetUVOffset(Vector2D _vUVOffset){m_vUVOffset=_vUVOffset;}
	inline	Vector2D GetUVOffset()const	 {return m_vUVOffset;}
	
	inline	void	 SetUVTiling(Vector2D _vUVTiling){m_vUVTiling=_vUVTiling;}
	inline	Vector2D GetUVTiling()const  {return m_vUVTiling;}
	
	inline	void	 SetUVAngle(float _fUVAngle){m_fUVAngle=_fUVAngle;}
	inline	float	 GetUVAngle()const	 {return m_fUVAngle;}
	
	inline	void	 SetUVBlur(float _fUVBlur){m_fUVBlur=_fUVBlur;}
	inline	float	 GetUVBlur()const	 {return m_fUVBlur;}
	
	inline	void	 SetUVBlurOffset(float _fUVBlurOffset){m_fUVBlurOffset=_fUVBlurOffset;}
	inline	float	 GetUVBlurOffset()const	 {return m_fUVBlurOffset;}
	
	inline	void	 SetNoiseAmt(float _fNoiseAmt){m_fNoiseAmt=_fNoiseAmt;}
	inline	float	 GetNoiseAmt()const	 {return m_fNoiseAmt;}
	
	inline	void	 SetNoiseSize(float _fNoiseSize){m_fNoiseSize=_fNoiseSize;}
	inline	float	 GetNoiseSize()const	 {return m_fNoiseSize;}
	
	inline	void	 SetNoiseLvl(int _nNoiseLvl){m_nNoiseLvl=_nNoiseLvl;}
	inline	int		 GetNoiseLvl()const	 {return m_nNoiseLvl;}
	
	inline	void	 SetNoisePhase(float _fNoisePhase){m_fNoisePhase=_fNoisePhase;}
	inline	float	 GetNoisePhase()const	 {return m_fNoisePhase;}

	void			  SetMapName(const char *strName);
	inline const char*GetMapName()const	 {return m_strMapName;}
	
};


class CTctMat:public CMaterial
{
	static const GLenum _eTexTargets[4];

	LinkList<CTctMap*> m_cMaps;
	LinkList<CTctAttribute*> m_cAttrs;
private:
	Vector3D		m_vAmbient;
	Vector3D		m_vDiffuse;
	Vector3D		m_vSpecular;
	
	float			m_fShine;
	float			m_fShineStr;
	float			m_fTransparency;
	float			m_fWireSize;
	unsigned		m_nMaterialID;
public:
	inline void		SetMaterialID(unsigned _nMatID){m_nMaterialID=_nMatID;}
	inline unsigned	GetMaterialID(){return m_nMaterialID;}
	
	inline void		SetAmbient(Vector3D _vAmbient){m_vAmbient=_vAmbient;}
	inline Vector3D GetAmbient()const   {return m_vAmbient;}
	
	inline void		SetDiffuse(Vector3D _vDiffuse){m_vDiffuse=_vDiffuse;}
	inline Vector3D GetDiffuse()const   {return m_vDiffuse;}
	
	inline void		SetSpecular(Vector3D _vSpecular){m_vSpecular=_vSpecular;}
	inline Vector3D GetSpecular()const   {return m_vSpecular;}
	
	inline void		SetShine(float _fShine){m_fShine=_fShine;}
	inline float	GetShine()const {return m_fShine;}
	
	inline void		SetShineStrength(float _fShineStr){m_fShineStr=_fShineStr;}
	inline float	GetShineStrength()const {return m_fShineStr;}
	
	inline void		SetTransparency(float _fTransparency){m_fTransparency=_fTransparency;}
	inline float	GetTransparency()const {return m_fTransparency;}
	
	inline void		SetWireSize(float _fWireSize){m_fWireSize=_fWireSize;}
	inline float	GetWireSize()const {return m_fWireSize;}
private:
	void			ProcessAttribute(const char *strName,TiXmlAttribute *pcAttribute);
public:
	CTctMat(const char *strFileName);
	~CTctMat();

	void			BeginUse();
	
	void			EndUse();
	
	CShaderObject * GetShader();
};


#endif
