#ifndef CANIMATIONPLAYER_HPP
#define CANIMATIONPLAYER_HPP

class CSubAnim;
class CAnimation;
class CRenderObject;
class CModel;

class CAnimationPlayer
{

private:
	CAnimation		*	m_pcAnimation;

	CSubAnim		**	m_pcSubObjBinds;

	unsigned			m_nBindCount;

	float				m_fProgress;

	CModel			*	m_pcLastBindedModel;
public:
	CAnimationPlayer(CAnimation *pcAnimation);
	~CAnimationPlayer();

	void			Clear();

	CModel*			GetBindedModel(){return m_pcLastBindedModel;}

	//Multiple render objects can bind to animation player,
	//Animation player doesn't point to renderobject it only
	//gather necessary info for sub-objects of renderobjects
	//Ex.
	//CRenderObject   *obj0,*obj1;
	//CAnimationPlayer*player;
	//...
	//obj0->AttachAnimPlayer(player);
	//obj1->AttachAnimPlayer(player);
	//...
	//Animation would be played for both render-objects
	void			GenerateAnimationData(CRenderObject *pcObject);

	bool			SetMatrixForSubObject(unsigned nObject);

	void			SetProgress(float fProgress){m_fProgress = fProgress;}



};

#endif