#ifndef CSUBANIM_HPP
#define CSUBANIM_HPP

#include "Types/ExtArray.hpp"
#include "Types/Quaternion.h"
#include "Types/Transform3D.h"

class CAnimEntity
{
public:
	Vector3D			m_vPosition;
	Vector3D			m_vScale;
	Quaternion			m_qRot;

	float				m_fAnimValue;
};

class CSubAnim
{
	friend class CAnimationManager;

	CAnimEntity				m_cInitialAnim;		//Pos,rot,scale of first frame

	ExtArray<CAnimEntity>   m_cAnimLst;			//Animation values
	
	char				 *	m_strName;			//Node name

	float					m_fAnimLength;		//Animation legnth

	float					m_fScale;			//Used for interpolation

	CSubAnim			 *  m_pcParent;			//Not used, points to parent animation

	Transform3D				m_vTransform;		//Used during matrix calculation
private:
	//For SetRotationMatrix
	//Don't recalculate anything, if the same t required
	float					m_mLastMatrix[16];
	Vector3D				m_vLastScale;
	float					m_fLastT;
private:
	//During animation
	int			 m_nEntityIndex;

	void		 GetAnimationValues(float t,Vector3D& vPosition,Vector3D& vScale,Quaternion& qRot);

	//Interpolation using m_nEntityIndex;
	void		 (CSubAnim::*InterpolatePositions)(Vector3D&	,float );
	void		 (CSubAnim::*InterpolateScales   )(Vector3D&	,float );
	void		 (CSubAnim::*InterpolateRotations)(Quaternion&,float );

	//Needs some calculations (uses values from array) (default)
	inline void		 InterpolatePositions_Arr (Vector3D& vPosition,float t)
	{
		vPosition = m_cAnimLst[m_nEntityIndex].m_vPosition + t * (m_cAnimLst[m_nEntityIndex+1].m_vPosition - m_cAnimLst[m_nEntityIndex].m_vPosition);
	}
	inline void		 InterpolateScales_Arr   (Vector3D& vScale,float t)
	{
		vScale	  = m_cAnimLst[m_nEntityIndex].m_vScale + t * (m_cAnimLst[m_nEntityIndex+1].m_vScale - m_cAnimLst[m_nEntityIndex].m_vScale);
	}
	inline void		 InterpolateRotations_Arr (Quaternion& qRot,float t)
	{
		qRot	  = slerp( m_cAnimLst[m_nEntityIndex].m_qRot, m_cAnimLst[m_nEntityIndex+1].m_qRot,t );
	}
	//Uses initial values
	inline void		 InterpolatePositions_NoArr (Vector3D& vPosition,float t)
	{
		vPosition = m_cInitialAnim.m_vPosition;
	}
	inline void		 InterpolateScales_NoArr   (Vector3D& vScale,float t)
	{
		vScale = m_cInitialAnim.m_vScale;
	}
	inline void		 InterpolateRotations_NoArr(Quaternion& qRot,float t)
	{
		qRot = m_cInitialAnim.m_qRot;
	}


private:
	//During loading
	void		 Begin();

	void		 Add(CAnimEntity cAnimEntity);

	void		 End();

	void		 SetPositionAnim(bool bEnable);
	void		 SetScaleAnim(bool bEnable);
	void		 SetRotAnim(bool bEnable);
public:
	CSubAnim(const char *strName);
	~CSubAnim();

	void		 SetParentAnim(CSubAnim *pcParent){m_pcParent = pcParent;}

	const char * GetName(){return m_strName;}

	void		 SetRotationMatrix(float t);
};

#endif