#ifndef _FRUSTUM_H
#define _FRUSTUM_H

#include "stdafx.h"
#include "Types/Vector3D.h"



struct Sphere 
{
	float xPos, yPos, zPos, radius;						// We want to hold a XYZ position and radius
	BYTE  r, g, b;										// These will store the color of the sphere
};





// This will allow us to create an object to keep track of our frustum
class CFrustum {

public:

	// Call this every time the camera moves to update the frustum
	void CalculateFrustum();

	// This takes a 3D point and returns TRUE if it's inside of the frustum
	bool PointInFrustum(const Vector3D& vec);

	// This takes a 3D point and a radius and returns TRUE if the sphere is inside of the frustum
	bool SphereInFrustum(float x, float y, float z, float radius);

	bool SphereInFrustum(const Vector3D& vec, float radius)
	{	return SphereInFrustum(vec.x,vec.y,vec.z,radius);	}

	// This takes the center and half the length of the cube.
	bool CubeInFrustum( const Vector3D& vec, float size );

	bool BoxInFrustum(const Vector3D& v1,const Vector3D& v2,const Vector3D& v3,const Vector3D& v4,
					  const Vector3D& v5,const Vector3D& v6,const Vector3D& v7,const Vector3D& v8);
	bool BoxInFrustum(const Vector3D& vMin,const Vector3D& vMax);

private:

	// This holds the A B C and D values for each side of our frustum.
	float m_Frustum[6][4];
};

extern CFrustum g_cFrustum;


#endif 


/////////////////////////////////////////////////////////////////////////////////
//
// * QUICK NOTES * 
//
// We added new structures and classes for our camera and frustum code.
// 
// 
// Ben Humphrey (DigiBen)
// Game Programmer
// DigiBen@GameTutorials.com
// Co-Web Host of www.GameTutorials.com
//
//