#ifndef CAMERA_H
#define CAMERA_H

#include "stdafx.h"
#include "Types/Vector3D.h"


class Camera
{
	Vector3D m_vEye;								
	Vector3D m_vAt;									
	Vector3D m_vUp;								
	
	Vector3D m_vLookVec;
	Vector3D m_vRightVec;
	Vector3D m_vUpVec;
	
	float	 m_fSpeed;

	float	 m_fModelViewTransposed[16];

	float	 m_fModelViewInitial[16];

	float	 m_fProjectionInitial[16];
	
public:
	Camera();	
	
	//Get Functions
	inline const Vector3D & GetEye()const{ return m_vEye;}
	inline const Vector3D & GetAt()const { return m_vAt;}
	inline const Vector3D & GetUp()const { return m_vUp;}
	
	inline const Vector3D & GetLookVec ()const { return m_vLookVec;}
	inline const Vector3D & GetRightVec()const { return m_vRightVec;}
	inline const Vector3D & GetUpVec   ()const { return m_vUpVec;}

	inline		 void		SetSpeed   (float fSpeed){m_fSpeed = fSpeed;}
	inline		 float		GetSpeed   ()const { return m_fSpeed;}

	inline		 float*		GetModelViewTransposed(){return m_fModelViewTransposed;}
	inline		 float*		GetModelViewInitial   (){return m_fModelViewInitial;}
	inline		 float*		GetProjectionInitial   (){return m_fProjectionInitial;}

	void PositionCamera(const Vector3D& _vEye,const Vector3D& _vAt,const Vector3D& _vUp);
	
	void PositionCamera(const Vector3D& _vEye,const Vector3D& _vAt);
	
	void SetMatrix();
	
	void CameraControls(float fDeltaTime);
	
	bool SetViewByMouse();          //true if changed
	
	void SwitchToOrthoView();
	
private:
	//Inner Camera Controls
	void RotateView(float angle, float X, float Y, float Z);
	
	void MoveCamera(float speed);

	void Strafe(float speed);
};

extern Camera g_cMainCam;


#endif