#pragma once

#include "Types/Vector4D.h"
#include "Types/Vector3D.h"
#include "Types/Vector2D.h"
#include "Types/Transform3D.h"
#include "Types/Matrix3D.h"

class CMaterial;
class CVBOBuffer;


class CRenderObject;
//Vertex 
class Vertex 
{
public:
	Vertex()
	{
		m_vVec=Vector3D(0,0,0);
		m_vColor=Vector4D(1,1,1,1);
		m_vUV=Vector2D(0,0);
		m_vNormal=Vector3D(1,0,0);
	}
	Vector3D m_vVec;
	Vector4D m_vColor;
	Vector2D m_vUV;
	Vector3D m_vNormal;
};

//Indices
class Indices
{
	unsigned	m_nNum;
	Vertex	   *m_pcIndices;
public:
	Indices();
	~Indices();

	void	SetNum(unsigned _nNum);

	unsigned GetNum()
	{
		return m_nNum;
	}

	Vertex& operator [] (unsigned n) 
	{ 
		return m_pcIndices[n]; 
	}
};

class Tris 
{
	struct STri 
	{
		unsigned t[3];
	}*m_pcTris;

	unsigned	m_nNum;
public:
	Tris();
	~Tris();

	void	SetNum(unsigned _nNum);

	unsigned GetNum()
	{
		return m_nNum;
	}
	STri& operator [] (unsigned n) 
	{ 
		return m_pcTris[n]; 
	}
};

class CRenderData
{
	//Collector is a friend
	friend class CRDC;
protected:
	char *			m_strName;
	CMaterial		*m_pcMaterial;
	Transform3D		m_tInitial;
	float			m_mInitial[16];
public:
	CRenderData(const char *strName = "Undefined");
	virtual ~CRenderData();

	inline const char * GetName(){return m_strName;}

	void				SetName(const char *strName);

	void				SetInitialTransform(const Transform3D& tInitial){m_tInitial = tInitial;m_tInitial.buildHomogeneousMatrix(m_mInitial);}

	Transform3D&		GetInitialTransform(){return m_tInitial;}

	float	   *		GetInitialOpenGlMatrix(){return m_mInitial;}
	
	inline CMaterial * GetMaterial()
	{
		return m_pcMaterial;
	}
	void SetMaterial(CMaterial *pcMat);
	
	static void AddDataToCollector(CRenderData *pcData);
	
	virtual void RD_BeginRender()=0;
	
	virtual void RD_Render()=0;
	
	virtual void RD_EndRender()=0;
};


class CRenderDataSimple:public CRenderData
{
public:
	enum  EGeometryType
	{
		GT_NONE		 = -1,
		GT_TRIANGLES = 0,
		GT_TRISTRIPS = 1
	};
protected:
	EGeometryType m_eGeomType;
	
	Indices		 *m_pcIndexLst;
	Tris		 *m_pcTriLst;
public:
	CRenderDataSimple();
	~CRenderDataSimple();
	
	inline void	SetGeomType(EGeometryType _gType)
	{
		m_eGeomType=_gType;
	}
	inline EGeometryType GetGeomType()
	{
		return m_eGeomType;
	} 
	inline Indices *GetIndexLst()
	{
		return m_pcIndexLst;
	}
	inline Tris * GetTriLst()
	{
		return m_pcTriLst;
	}

	void	RD_BeginRender();	
	
	void	RD_Render();
	
	void	RD_EndRender();
};

class CRenderDataVBO:public CRenderData
{
protected:
	CVBOBuffer *m_pcBuf;	
public:
	CRenderDataVBO();
	~CRenderDataVBO();
	
	void		CreateBufferFromSimple(CRenderDataSimple *pcSimpleData);
	
	CVBOBuffer	*GetBuffer()
	{
		return m_pcBuf;
	}
	
	void	SetBuffer(CVBOBuffer *_pcBuf);
	
	void	DeleteBuffer();
	
	void	RD_BeginRender();
	
	void	RD_Render();
	
	void	RD_EndRender();
};


