#ifndef CRENDEROBJECT_HPP
#define CRENDEROBJECT_HPP

#include "Types/Transform3D.h"
#include "Models/CModel.hpp"




class CModel;
class CAnimationPlayer;

class CRenderObject:public CObject
{
private:
	//Local storage for opengl matrix
	float			 m_mOpenGl[16];
	
	Transform3D		 m_cTransform;

	Vector3D		 m_vScale;
	
	BoundingBox		 m_cTransformedBox;
	
	CModel			*m_pcModel;

	CAnimationPlayer*m_pcAnimPlayer;
	
private:
	inline void	UpdateTransform()
	{
		m_cTransform.buildHomogeneousMatrix(m_mOpenGl);
		m_cTransformedBox=m_pcModel->GetBoundingBox();
		m_cTransformedBox.minPoint.x*=m_vScale.x;
		m_cTransformedBox.minPoint.y*=m_vScale.y;
		m_cTransformedBox.minPoint.z*=m_vScale.z;
		m_cTransformedBox.maxPoint.x*=m_vScale.x;
		m_cTransformedBox.maxPoint.y*=m_vScale.y;
		m_cTransformedBox.maxPoint.z*=m_vScale.z;
		m_cTransformedBox.apply(m_cTransform);
	}
	
public:
	CRenderObject(CModel *_pcModel);
	~CRenderObject();

	void   AttachAnimPlayer(CAnimationPlayer *pcPlayer);

	void   SwitchToPlayer(CAnimationPlayer *pcPlayer);

	bool   IsVisible();
	
	inline BoundingBox& GetBoundingBox()
	{	
		return m_cTransformedBox;
	}
	inline CModel*  GetModel()
	{
		return m_pcModel;
	}
	inline void		SetTranform(const Transform3D& _cTrans)
	{
		m_cTransform=_cTrans;
		UpdateTransform();
	}
	inline void		SetPosition(const Vector3D& _vPos)
	{
		m_cTransform.v=_vPos;
		UpdateTransform();
	}
	inline void		SetRotation(const Matrix3D& _mRot)
	{
		m_cTransform.m=_mRot;
		UpdateTransform();
	}
	inline void		SetScale(const Vector3D& vScale)
	{
		m_vScale = vScale;
	}
	inline Transform3D	GetTranform()const
	{
		return m_cTransform;
	}
	inline Vector3D		GetPosition()const
	{
		return m_cTransform.v;
	}
	inline Matrix3D		GetRotation()const
	{
		return m_cTransform.m;
	}
	inline Vector3D		GetScale()const
	{
		return m_vScale;
	}
	
	void   Render();
	
	void   RenderBoundingBox();
};



#endif