#ifndef CATTRIBUTE_HPP
#define CATTRIBUTE_HPP

#include "Types/Vector2D.h"
#include "Types/Vector3D.h"
#include "Types/Vector4D.h"
#include "Types/Matrix3D.h"
#include "Types/Matrix4D.h"

class CAttribute
{
	static const unsigned	m_cnValStrLen = 256;
public:
	union UValue
	{
		char		strValue[m_cnValStrLen];
		float		fValue;
		int			iValue;
		short		nValue;
		bool		bValue;
		float		vValue2D[2];
		float		vValue3D[3];
		float		vValue4D[3];
		float		mValue3[3][3];
		float		mValue4[4][4];
	};
	enum EValueType
	{
		VT_UNDEFINED,
		VT_STRING,
		VT_FLOAT,
		VT_INT,
		VT_SHORT,
		VT_BOOL,
		VT_VEC2,
		VT_VEC3,
		VT_VEC4,
		VT_MAT3,
		VT_MAT4
	};
private:
	//Used for string format
	char		m_strFloatFormat[50];
	char		m_strVec2Format[50];
	char		m_strVec3Format[50];
	char		m_strVec4Format[50];
	char		m_strMat3Format[100];
	char		m_strMat4Format[100];

	unsigned	m_nFloatPrecision;

	char		*m_strName;

	UValue		m_uValue;

	EValueType  m_eValueType;
private:
	void	InitData(const char *strName);
public:
	CAttribute(const char *strName = "null",const char *strValue = "null");
	CAttribute(const char *strName,float		  fValue);
	CAttribute(const char *strName,int		  iValue);
	CAttribute(const char *strName,short		  nValue);
	CAttribute(const char *strName,bool		  bValue);
	CAttribute(const char *strName,const Vector2D& vValue2D);
	CAttribute(const char *strName,const Vector3D& vValue3D);
	CAttribute(const char *strName,const Vector4D& vValue4D);
	CAttribute(const char *strName,const Matrix3D& mValue3);
	CAttribute(const char *strName,const Matrix4D& mValue4);

	~CAttribute();

	void			SetFloatPrecision(unsigned nFloatPrecision);


	void			SetName(const char *strName);
	const char *	GetName(){ return m_strName;}
	EValueType		GetValType(){ return m_eValueType;}

	//Any Type Can be converted to string
	const char *	ConvertToString();
	//Property can be converted, if it was a string
	float			ConvertToFloat();
	int				ConvertToInt();
	short			ConvertToShort();
	bool			ConvertToBool();
	Vector2D		ConvertToVector2D();
	Vector3D		ConvertToVector3D();
	Vector4D		ConvertToVector4D();
	Matrix3D		ConvertToMatrix3D();
	Matrix4D		ConvertToMatrix4D();

	const char *	GetString()const;
	float			GetFloat()const;
	int				GetInt()const;
	short			GetShort()const;
	bool			GetBool()const;
	Vector2D		GetVector2D()const;
	Vector3D		GetVector3D()const;
	Vector4D		GetVector4D()const;
	Matrix3D		GetMatrix3D()const;
	Matrix4D		GetMatrix4D()const;

	void			SetString(const char *strValue);
	void			SetFloat(float		  fValue);
	void			SetInt(int		  iValue);
	void			SetShort(short		  nValue);
	void			SetBool(bool		  bValue);
	void			SetVector2D(const Vector2D& vValue2D);
	void			SetVector3D(const Vector3D& vValue3D);
	void			SetVector4D(const Vector4D& vValue4D);
	void			SetMatrix3D(const Matrix3D& mValue3);
	void			SetMatrix4D(const Matrix4D& mValue4);
};

#endif