#ifndef CATTRGROUP_HPP
#define CATTRGROUP_HPP

#include "Types/Hash.hpp"

class CAttribute;

class CAttributeGroup 
{
	MapHash<CAttribute*> m_pcAttrs;
	char			* m_strName;

public:
	CAttributeGroup(const char* strName);
	~CAttributeGroup();

	void		Clear();

	const char* GetName(){return m_strName;}

	unsigned	Count();

	bool		AddAttribute(CAttribute *pcNewAttr);
	bool		RemoveAttribute(CAttribute *pcNewAttr);
	bool		RemoveAttribute(const char *strName);
	CAttribute * FindAttribute(const char *strName);

	HashItem<CAttribute*> *CAttributeGroup::GetNextAttribute(HashItem<CAttribute*> *pcItem);

};

#endif