#ifndef CFILEREADER_HPP
#define CFILEREADER_HPP

#include "Platform/Platform.h"
#include "Types/Vector2D.h"
#include "Types/Vector3D.h"
#include "Types/Vector4D.h"
#include "Types/Quaternion.h"

class CFileReader
{
	unsigned	char		*m_pcBuffer;

	unsigned	 m_nCurPtr;

	unsigned	 m_nSize;
public:
	CFileReader();
	~CFileReader();

	bool		OpenFile(const char *strName);
	void		CloseFile();

	const	unsigned&	GetCurPtr()const{return m_nCurPtr;}
	//Returns size in bytes
	const	unsigned&	GetSize()  const{return m_nSize;}

	const	unsigned char*GetBuffer()const{return m_pcBuffer;}

	//Read Functions
	//Read Functions

	inline void ReadBuffer(void* pcBuffer,unsigned nCount)
	{
		memcpy(pcBuffer,&m_pcBuffer[m_nCurPtr],nCount);
		m_nCurPtr+=nCount;
	}

	inline void ReadString(char* strResult,unsigned nCount)
	{
		unsigned nCurrent = 0;
		while(m_pcBuffer[m_nCurPtr]!=13 && m_pcBuffer[m_nCurPtr]!=0 && nCurrent+1<nCount)
		{
			strResult[nCurrent] = m_pcBuffer[m_nCurPtr];
			nCurrent++;
			m_nCurPtr++;
		}

		m_nCurPtr++;
		strResult[nCurrent] = '\0';
	}

	inline int8  ReadInt8()
	{
		return m_pcBuffer[m_nCurPtr++];
	}
	inline uint8  ReadUint8()
	{
		return uint8(m_pcBuffer[m_nCurPtr++]);
	}
	inline int32 ReadInt32()
	{
		int32 n=*(int32*)&m_pcBuffer[m_nCurPtr];
		m_nCurPtr+=4;
		return n;
	}
	inline int32 ReadUint32()
	{
		uint32 n=*(uint32*)&m_pcBuffer[m_nCurPtr];
		m_nCurPtr+=4;
		return n;
	}
	inline float CFileReader::ReadFloat32()
	{
		float f=*(float*)&m_pcBuffer[m_nCurPtr];
		m_nCurPtr+=4;
		return f;
	}
	inline Quaternion CFileReader::ReadQuaternion()
	{
		Quaternion qResult;
		qResult.x = ReadFloat32();
		qResult.y = ReadFloat32();
		qResult.z = ReadFloat32();
		qResult.w = ReadFloat32();
		return qResult;
	}
	inline Vector4D CFileReader::ReadVector4D()
	{
		Vector4D vResult;
		vResult.x = ReadFloat32();
		vResult.y = ReadFloat32();
		vResult.z = ReadFloat32();
		vResult.w = ReadFloat32();
		return vResult;
	}
	inline Vector3D CFileReader::ReadVector3D()
	{
		Vector3D vResult;
		vResult.x = ReadFloat32();
		vResult.y = ReadFloat32();
		vResult.z = ReadFloat32();
		return vResult;
	}
	inline Vector2D CFileReader::ReadVector2D()
	{

		Vector2D vResult;
		vResult.x = ReadFloat32();
		vResult.y = ReadFloat32();
		return vResult;
	}

};


#endif