#ifndef CMOUSESTATE_H
#define CMOUSESTATE_H

#include "Types/Vector3D.h"

class CMouseState 
{
	bool	m_bChanged;
	bool	m_bMouseMoved;

	int		m_nMX,m_nMY;
	int		m_nLastMX,m_nLastMY;

	enum	SButtonMouseState
	{
		BMS_PRESSED		= 0,
		BMS_NOTPRESSED	= 1
	};

	struct  SButton
	{
		bool				m_bChanged;
		SButtonMouseState	m_nState;
	}m_cButton[2];							//Left-Right

	SButtonMouseState		m_cLastState[2];
private:
	//Projection from 2D to 3D
	Vector3D		m_vOrg;
	Vector3D		m_vDir;
	unsigned	int m_nLastFrame;
public:

	CMouseState();

	void	ButtonPressed	(int nButton);
	void	ButtonUnPressed (int nButton);
	
	void	OnMouseMoved	(int nMX,int nMY);

	bool	GetButton		(int nButton);
	bool	Changed			(int nButton);
	bool	Pressed			(int nButton){return GetButton(nButton) && Changed(nButton);}

	void	GetMouseCoord	(int &nMX,int &nMY);

	void	GetDeltaCoord	(int &nMX,int &nMY);

	void	Update();
	
	
	//Projected Ray
	void    GetProjection(Vector3D& vOrg,Vector3D& vDir);

};


extern CMouseState g_cMouse;


#endif