#ifndef CSHADERATTRIBUTE_HPP
#define CSHADERATTRIBUTE_HPP

#include "Types/Vector2D.h"
#include "Types/Vector3D.h"

class CShaderAttr
{
	unsigned int m_nAttrType;		//0 - not initialize, 1 - float , 2 - vec2 , 3 - vec3
	unsigned int m_nAttrLoc;		//Attribute Location
	unsigned int m_nBindID;			//Bind ID to Opengl ARB buffer
	
	float	 *m_pcSingleType;
	Vector2D *m_pcVec2Type;
	Vector3D *m_pcVec3Type;
	
	unsigned int m_nMaxCount;
	unsigned int m_nCurCount;
	
public:
	CShaderAttr();
	~CShaderAttr();
	
	inline  unsigned int GetCount()
	{
		return m_nCurCount;
	}
	//Allocates memory, sets Attribute Location
	void	DataInit(unsigned int _nAttrType,unsigned int _nMaxCount,unsigned int _nAttrLoc);
	
	void	DataAdd (const float   & _sData);
	void    DataAdd (const Vector2D& _sData);
	void	DataAdd (const Vector3D& _sData);
	
	//Binds and generate buffer
	void	DataFinish();
	
	//When drawing begin/end
	void	BeginUse();
	
	void	EndUse();
	
};

#endif