#ifndef CMISCCOLLISIONS_HPP
#define CMISCCOLLISIONS_HPP

#include "Types/Vector3D.h"

bool FindTriLineCollision(Vector3D vTr0,Vector3D vTr1,Vector3D vTr2,
                          Vector3D vL0 ,Vector3D vL1 ,Vector3D &c,Vector3D &n,bool bSkipBack=true);

//FindRayTriCollision
//Input:
//vP0,vP1,vP2 - points of triangle
//vOrg,vDir   - origin and direction of ray, direction can be normalized and not normalized,
//			    fDelta would be bigger(by ray length) for the same ray with normalized direction
//fEps		  - ray/tri tollerance, there's no collision if ray is parallel to triangle
//Output:
//true/false  - for collision
//vResult	  - collision point
//vNormal	  - tri normal
//fOmega	  - DotProduct(-ray.dir,tri.normal) (Be careful minus - so if fOmega is -1.0f , the ray hits triangle in back, if fOmega is 1.0f - in front
//fDelta	  - vResult = vOrg + vDir*fDelta
//Note: if ray hits tri edge, collision still exists !!!!


bool FindRayTriCollision(const Vector3D& vP0,
						 const Vector3D& vP1,
						 const Vector3D& vP2,
						 const Vector3D& vOrg,
						 const Vector3D& vDir,
						 Vector3D& vResult,
						 Vector3D& vNormal,
						 float &fOmega,
						 float &fDelta,
						 float fEps = EPS);

/*
void  FindNormalAndDistance(Vector3D vTr0,Vector3D vTr1,Vector3D vTr2,Vector3D &n,float &d);  

float GetDistanceToPlane(Vector3D vPoint,Vector3D vNormal,float nDist);
*/
float ClosestPointOnLine(Vector3D vL0 ,Vector3D vL1,Vector3D vPoint,Vector3D &vResult);




float GetClosestPointOnTriEdges(Vector3D vTr0,Vector3D vTr1,Vector3D vTr2,Vector3D vPoint,Vector3D &vResult);

/*
bool  FindLineLineCollision(Vector3D vL0,Vector3D vL1,Vector3D vLL0,Vector3D vLL1,Vector3D &vResult);
*/



//Return Closest Point on Ray vOrg+t*vDir, p - point is our "close" target
//vDir has to be normalized
Vector3D GetClosestPointFromRay(const Vector3D& vOrg,const Vector3D& vDir,const Vector3D& p);


//Return Distance from Ray vOrg+t*vDir to p - point
//vDir has to be normalized
float    GetDistanceFromRay(const Vector3D& vOrg,const Vector3D& vDir,const Vector3D& p);

//Returns true, if there is collision - vResult is Collision Points
//vDir doesnt has to be normalized (didnt check that)
//bHitBack - true, when we hited back of the plane
bool	 GetRayPlaneCollision(const Vector3D& vOrg,const Vector3D& vDir,
							  const float& d,const Vector3D& n,Vector3D& vResult,bool& bHitBack);

bool	GetRayXYPlaneCollision(const Vector3D& vOrg,const Vector3D& vDir,const float &d,Vector3D& vResult,bool& bHitBack);
bool	GetRayXZPlaneCollision(const Vector3D& vOrg,const Vector3D& vDir,const float &d,Vector3D& vResult,bool& bHitBack);
bool	GetRayYZPlaneCollision(const Vector3D& vOrg,const Vector3D& vDir,const float &d,Vector3D& vResult,bool& bHitBack);

#endif