#ifndef CSHADEROBJECT_HPP 
#define CSHADEROBJECT_HPP

#include "CShaderProgram.hpp"
#include "stdafx.h"


class CShaderObject
{
private:
	char *m_strName;
public:
	CShaderObject(const char *strName);            // Standard Constructor
	~CShaderObject();           // Destructor

	void addShader(CShaderProgram* ShaderProgram); //!< add a Vertex or Fragment Program

	bool link(void);            //!< Link all Shaders
	const char* getLinkerLog(void);   //!< get Linker messages

	void begin();	//!< use Shader. OpenGL calls will go through shader.
	void end();		//!< Stop using this shader. OpenGL calls will go through regular pipeline.

	bool oglslEnabled(void);    //!< returns true if OGLSL is enabled. It is possible user hardware doesn't support OGLSL!

	// Send Variables to Program

	bool sendUniform1f(const char* varname, GLfloat v0); //!< send float to program
	bool sendUniform2f(const char* varname, GLfloat v0, GLfloat v1); //!< send vec2 to program
	bool sendUniform3f(const char* varname, GLfloat v0, GLfloat v1, GLfloat v2); //!< send vec3 to program
	bool sendUniform4f(const char* varname, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3); //!< send vec4 to program

	bool sendUniform1i(const char* varname, GLint v0);
	bool sendUniform2i(const char* varname, GLint v0, GLint v1);
	bool sendUniform3i(const char* varname, GLint v0, GLint v1, GLint v2);
	bool sendUniform4i(const char* varname, GLint v0, GLint v1, GLint v2, GLint v3);

	bool sendUniform1fv(const char* varname, GLsizei count, GLfloat *value);
	bool sendUniform2fv(const char* varname, GLsizei count, GLfloat *value);
	bool sendUniform3fv(const char* varname, GLsizei count, GLfloat *value);
	bool sendUniform4fv(const char* varname, GLsizei count, GLfloat *value);

	bool sendUniform1iv(const char* varname, GLsizei count, GLint *value);
	bool sendUniform2iv(const char* varname, GLsizei count, GLint *value);
	bool sendUniform3iv(const char* varname, GLsizei count, GLint *value);
	bool sendUniform4iv(const char* varname, GLsizei count, GLint *value);

	bool sendUniformMatrix2fv(const char* varname, GLsizei count, GLboolean transpose, GLfloat *value);
	bool sendUniformMatrix3fv(const char* varname, GLsizei count, GLboolean transpose, GLfloat *value);
	bool sendUniformMatrix4fv(const char* varname, GLsizei count, GLboolean transpose, GLfloat *value);


	// Receive Uniform variables:
	void GetUniformfv(const char* name, GLfloat* values);
	void GetUniformiv(const char* name, GLint* values); 


	void manageMemory(void){_mM = true;}

	GLint GetAttribLocation(const GLcharARB *name);

	bool  CheckUniformLocation(const GLcharARB *name);

	inline const char * GetName()const{return m_strName;}

private:
	GLint GetUniLoc		(const GLcharARB *name);      // get location of a variable

	GLhandleARB         ShaderObject;            // Shader Object


	GLcharARB*          linker_log;
	bool                is_linked;
	std::vector<CShaderProgram*> ShaderList;     // List of all Shader Programs

	bool                _mM;
	static bool			m_bShaderOpLocked;
public:
	static	void		LockShaderOperations(){m_bShaderOpLocked = true;}
	static	void		UnLockShaderOperations(){m_bShaderOpLocked = false;}
	static  bool		IfShaderOperationsLocked(){ return m_bShaderOpLocked;}
	

};
#endif