#ifndef CSHADERPROGRAM_HPP
#define CSHADERPROGRAM_HPP

#include "stdafx.h"
#include "Opengl/OpenGLExtensions.h"


class CShaderProgram
{
	friend class CShaderObject;

public:
	CShaderProgram();
	~CShaderProgram();

	int load(char* filename);   //!< read file, if result is 0 everything is ok. -1: File not found, -2: Empty File, -3: no memory
	void LoadFromMemory(const char* program); //!< load program from char array, make sure program is 0 terminated! 


	bool compile(void);         //!< compile program

	char* getCompilerLog(void);  //!< get compiler messages

	char* getShaderSource()
	{
		return (char*)ShaderSource;
	}

protected:

	int                 program_type;          //!< 1=Vertex Program, 2=Fragment Program, 0=none

	GLhandleARB         ProgramObject;         //!< Program Object
	GLubyte*            ShaderSource;          //!< ASCII Source-Code

	GLcharARB*          compiler_log;

	bool                is_compiled;            //!< true if compiled
	bool                _memalloc;               //!< true if shader allocated memory


};

#endif