#ifndef CTEXTURE_HPP
#define CTEXTURE_HPP

#include "stdafx.h"

class CTexture
{
	friend class CTextureManager;
public:
	enum ETextureType
	{
		TT_Tex2D	= 0,
		TT_Tex3D	= 1,
		TT_Noise	= 2,
		TT_CubeMap	= 3
	};
private:
	unsigned int	m_nWidth;
	unsigned int	m_nHeight;
	unsigned int    m_nDepth;

	unsigned int 	m_nFormat;
	int				m_nInternalFormat;
	unsigned int 	m_nTextureId;
	unsigned int    m_nDevilID;

	unsigned		m_nReplaceTexture;
	ETextureType	m_eTextureType;
private:
	//Processed by DevIL library
	unsigned char  *m_pcTexels;
public:
	CTexture();
	~CTexture();

	inline		  unsigned int GetWidth()const			{return m_nWidth;}
	inline		  unsigned int GetHeight()const			{return m_nHeight;}
	inline		  unsigned int GetFormat()const			{return m_nFormat;}
	inline				   int GetInternalFormat()const {return m_nInternalFormat;}
	inline		  unsigned int GetTextureId()const		{return m_nReplaceTexture==0?m_nTextureId:m_nReplaceTexture;}
	inline		  unsigned int GetDevilId()const		{return m_nDevilID;}
	inline		  ETextureType GetTexType()const		{return m_eTextureType;}

	inline		  void		   ReplaceTexture(unsigned int nDst = 0){m_nReplaceTexture = nDst;}


	

};


#endif
