#ifndef __EXTARRAY_HPP__
#define __EXTARRAY_HPP__

#ifndef NULL
#define NULL 0
#endif

#include "ErrorCheck.h"


template <class ItemData> class ExtArray {
private:
    unsigned memadd;
    unsigned memsize;
    unsigned len;
    ItemData *arr;

public:

    ExtArray(unsigned _memadd = 5):memadd(_memadd),memsize(0),len(0),arr(NULL) {}
    ~ExtArray() {if (arr!=NULL) free(arr); }
    
    unsigned Length() { return len; }
    
    void SetMemAdd(unsigned _add)
    {
		ASSERT(memadd>0,"Memadd too small:%d",_add);
		memadd=_add;
    }

    void SetLength(unsigned n) {
        len = n;
        if (len>=memsize) { 
            memsize = len+memadd; 
            arr = (ItemData*)realloc(arr,memsize*sizeof(ItemData)); 
        }
    }

    void Add(ItemData data) {
        if (len>=memsize) { 
            memsize+=memadd; 
            arr = (ItemData*)realloc(arr,memsize*sizeof(ItemData)); 
        }
        arr[len++]=data;
    }
	ItemData& AddByReference()
	{
		if (len>=memsize) { 
            memsize+=memadd; 
            arr = (ItemData*)realloc(arr,memsize*sizeof(ItemData)); 
        }
	    return arr[len++];
	}

    void Clear() {
		if (arr!=NULL) {
            free(arr);
            arr = NULL;
        }
        memsize = 0;
        len = 0;
    }


    ItemData& operator [] (unsigned n) { 
		ASSERT(n>=0 && n<len,"Array index out of bounds");
        return arr[n]; 
    }


};

#include "NoMemoryMan.h"

#endif
