#ifndef HASH_HPP__
#define HASH_HPP__


#include "ErrorCheck.h"

#ifndef NULL
#define NULL 0
#endif

/** Maximum hash key length */
#define KEYMAXLEN 0x100

//---------------------------------------------------------------------------
// Some utility functions
//---------------------------------------------------------------------------

static char uptable[0x100] = {
'\x00','\x01','\x02','\x03','\x04','\x05','\x06','\x07','\x08','\x09','\x0A','\x0B','\x0C','\x0D','\x0E','\x0F',
'\x10','\x11','\x12','\x13','\x14','\x15','\x16','\x17','\x18','\x19','\x1A','\x1B','\x1C','\x1D','\x1E','\x1F',
'\x20','\x21','\x22','\x23','\x24','\x25','\x26','\x27','\x28','\x29','\x2A','\x2B','\x2C','\x2D','\x2E','\x2F',
'\x30','\x31','\x32','\x33','\x34','\x35','\x36','\x37','\x38','\x39','\x3A','\x3B','\x3C','\x3D','\x3E','\x3F',
'\x40','\x41','\x42','\x43','\x44','\x45','\x46','\x47','\x48','\x49','\x4A','\x4B','\x4C','\x4D','\x4E','\x4F',
'\x50','\x51','\x52','\x53','\x54','\x55','\x56','\x57','\x58','\x59','\x5A','\x5B','\x5C','\x5D','\x5E','\x5F',
'\x60','\x41','\x42','\x43','\x44','\x45','\x46','\x47','\x48','\x49','\x4A','\x4B','\x4C','\x4D','\x4E','\x4F',
'\x50','\x51','\x52','\x53','\x54','\x55','\x56','\x57','\x58','\x59','\x5A','\x7B','\x7C','\x7D','\x7E','\x7F',
'\x80','\x81','\x82','\x83','\x84','\x85','\x86','\x87','\x88','\x89','\x8A','\x8B','\x8C','\x8D','\x8E','\x8F',
'\x90','\x91','\x92','\x93','\x94','\x95','\x96','\x97','\x98','\x99','\x9A','\x9B','\x9C','\x9D','\x9E','\x9F',
'\xA0','\xA1','\xA2','\xA3','\xA4','\xA5','\xA6','\xA7','\xA8','\xA9','\xAA','\xAB','\xAC','\xAD','\xAE','\xAF',
'\xB0','\xB1','\xB2','\xB3','\xB4','\xB5','\xB6','\xB7','\xB8','\xB9','\xBA','\xBB','\xBC','\xBD','\xBE','\xBF',
'\xC0','\xC1','\xC2','\xC3','\xC4','\xC5','\xC6','\xC7','\xC8','\xC9','\xCA','\xCB','\xCC','\xCD','\xCE','\xCF',
'\xD0','\xD1','\xD2','\xD3','\xD4','\xD5','\xD6','\xD7','\xD8','\xD9','\xDA','\xDB','\xDC','\xDD','\xDE','\xDF',
'\xE0','\xE1','\xE2','\xE3','\xE4','\xE5','\xE6','\xE7','\xE8','\xE9','\xEA','\xEB','\xEC','\xED','\xEE','\xEF',
'\xF0','\xF1','\xF2','\xF3','\xF4','\xF5','\xF6','\xF7','\xF8','\xF9','\xFA','\xFB','\xFC','\xFD','\xFE','\xFF',
};

inline bool eq(const char* s1, const char* s2) {
    while (*s1!=0) {
        if (*s1!=*s2) return false;
        s1++; s2++;
    }
    return *s1==*s2;
}

inline void up(char *dst, const char *src) {
    while (*src!=0) {
        *dst=uptable[*src];
        src++; dst++;
    }
    *dst=0;
}

template <class HashItemData> class MapHash; // prototype


template <class HashItemData> class HashItem {

    friend class MapHash<HashItemData>;

private:
    char *key;
    HashItem *next,*last;
    HashItem *lprev,*lnext;

    HashItem(const char* _key, HashItemData _data):data(_data) {
        key = new char[strlen(_key)+1]; 
        up(key,_key);
        //for (int i=0; _key[i]!=0; i++) key[i]=toupper(_key[i]);
        //key[i]=0;
    }

    ~HashItem() {
         delete[] key;
    }

public:
    /** value saved with this item */
    HashItemData data;
    /** key associated with item */
    inline char *getKey() { return key; }
};

/**
 * MapHash allows to make association between id character string and value.
 * Id should be unique.<br>
 * The main purpose is to give you fast access to the value by given id.<br>
 */
template <class HashItemData> class MapHash {

private:
    const int Size;     // hashTablo dydis
    int count;          // elementu skaicius

    HashItem<HashItemData>** hash; // lentele
    HashItem<HashItemData> *lfirst,*llast; // dvipusis sarasas

    int hashCode; // local for remove acceleration

    int Code(const char* key) {
        unsigned int result = 0;
        for (int i=0; key[i]!=0; i++) {
            result = (result<<5)+key[i];
            if (result>=0x03FFFFE0) result%=(unsigned int)Size;
        }
        if (result<(unsigned int)Size) return result;
        return result%(unsigned int)Size;
    }

public:
    static int PreferredSize(int count) {
        int cnt2 = (int)(count*1.14)+1; 
        if (!(cnt2&1)) cnt2++;
        bool done;
        do {
            done = true;
            for (int i=3; i<=cnt2/2; i+=2) {
                if (cnt2%i==0) { // if not a prime, go next number
                    done=false; cnt2+=2; break;
                } 
            }
        } while (!done);
        return cnt2;
    }
    

    MapHash(int _Size = 113):Size(_Size),count(0),lfirst(NULL),llast(NULL) {
		typedef HashItem<HashItemData>* T;
        hash = new T[Size];
        for (int i=0; i<Size; i++) hash[i] = NULL;
    }



    ~MapHash() {
		Clear();
        delete[] hash;
    }
	void Clear()
	{
		for (int i=0; i<Size; i++) 
		{
			HashItem<HashItemData>* hi = hash[i];
			HashItem<HashItemData>* hDel;
			while (hi!=NULL)
			{		
				 hDel=hi;
				 hi = hi->next; 
				 delete hDel;
			}
			hash[i]=NULL;
		}
		count = 0;
		lfirst= NULL;
		llast = NULL;
	}
	
	//Dont Forget to call clear after ClearData(), if your intention was to delete hole list
	void ClearData()
	{
		for(HashItem <HashItemData> *pcItem=Next(NULL);
			pcItem!=NULL;
			pcItem=Next(pcItem))
		{
			delete pcItem->data;
		}
	}
    /**
     * Get stored elements count
     * @return int Stored elements count
     */
    int Count() { return count; }


    HashItem<HashItemData>* Add(const char* key, HashItemData data) {
        HashItem<HashItemData>* hi = new HashItem<HashItemData>(key,data);
        key = hi->key;
       
        hi->next = NULL;
        hi->lnext = NULL;

        int h = Code(key);
        if (hash[h]==NULL) {
            hash[h] = hi; 
        } else {
            hash[h]->last->next = hi;
        }
        hash[h]->last = hi;

        // add to list
        if (lfirst==NULL) {
            lfirst = hi; hi->lprev = NULL;
        } else {
            llast->lnext = hi; hi->lprev = llast;
        }
        llast = hi;

        count++;
        return hi;
    }


    HashItem<HashItemData>* Find(const char* key) {
        if (key==NULL) return NULL;
        char k[KEYMAXLEN];
        up(k,key);
        hashCode = Code(k);
        HashItem<HashItemData>* hi = hash[hashCode];
        while (hi!=NULL) {
            if (eq(hi->key,k)) return hi;
            hi = hi->next;
        }
        return NULL;
    }
    /**
     * Remove from hash value associated with id
     */
    void Remove(const char *key) {
        HashItem<HashItemData>* hi = Find(key);
        int h = hashCode;//Code(hi->key);
        HashItem<HashItemData>* hi2 = hash[h];
        if (hi2==hi) {
            hash[h] = hi->next;
            if (hash[h]!=NULL) hash[h]->last = hi->last;
        } else {
            while (hi2!=NULL) {
                if (hi2->next==hi) {
                    hi2->next = hi->next;
                    if (hi->next==NULL) hash[h]->last = hi2;
                    break;
                }
                hi2 = hi2->next;
            }
        }
        // remove from list
        if (hi->lprev!=NULL) hi->lprev->lnext = hi->lnext;
        if (hi->lnext!=NULL) hi->lnext->lprev = hi->lprev;
        if (hi==lfirst) lfirst = hi->lnext;
        if (hi==llast) llast = hi->lprev;
        // free memory
        delete hi;

        count--;
    }

    /**
     * Function to list all hash items.
     * Usage:<pre>
     * // MapHash&lt;type&gt; *hash defined elsewhere
     * HashItem&lt;type&gt; *hi = hash->Next(NULL); // access 1st element
     * while (hi!=NULL) { // when hi==NULL - all elements passed
     *     // do something with hi->data
     *     ...
     *     // go to next element
     *     hi = hash->Next(hi); 
     * }
     * </pre>
     * @param hi HashItem we want to obtain next element for. 
     * If NULL then 1st element will be returned.
     * @return HashItem next to hi in hash. NULL if there's no such elements.
     */
    inline HashItem<HashItemData>* Next(HashItem<HashItemData>* hi) {
        return (hi==NULL)?lfirst:hi->lnext;
    }

    void Statistics(int *entries,int *collisions,int *size) {
        *entries = 0; *collisions = 0; *size = Size;
        for (int i=0; i<Size; i++) 
            if (hash[i]!=NULL) {
                (*entries)++; 
                HashItem<HashItemData>* hi = hash[i]->next;
                while (hi!=NULL) { 
                    (*collisions)++;  hi = hi->next; 
                }
            }
    }

    /** Check if hash is empty 
     * @return true if empty
     */
    inline bool Empty() { return (lfirst==NULL); }
};

#include "NoMemoryMan.h"

#endif //__HASH_HPP__
