//
// Simple 1-D math
//
// Author: Alex V. Boreskoff
//

#ifndef	__MATH_1D__
#define	__MATH_1D__

#include	<math.h>
#include	<stdlib.h>						// for rand
#include	<Windows.h>

#ifndef	M_PI								// since not all compilers define it						
#define M_PI        3.14159265358979323846f
#endif


inline	int	sign ( float val )
{
	return val < 0 ? -1 : ( val > 0 ? 1 : 0 );
}

inline	int	iClamp ( int val, int from = 0, int to = 1 )
{
	if ( val < from )
		return from;
	else
		if ( val > to )
			return to;

	return val;
}

inline	float	fClamp ( float val, float from = 0, float to = 1 )
{
	if ( val < from )
		return from;
	else
	if ( val > to )
		return to;

	return val;
}
inline	float	fSquare (float x){return x*x;}
//Random
inline float	fMax(float a,float b){return a>b?a:b;}
inline float	fMin(float a,float b){return a<b?a:b;}
inline float	fRandom(){return 2 * float ( rand() ) / float ( RAND_MAX ) - 1;}
inline float	fRandom(float max) { return (max>0) ? rand()*max/RAND_MAX : 0; }
inline float	fRandom(float min, float max) { return (max>min) ? min + rand()*(max-min)/RAND_MAX : min; }
inline int		iRandom(int max) { return (max>0) ? rand()%max : 0; }
inline int		iRendom(int min,int max) { return (max>min) ? min + rand()%(max-min) : min; }
//Interpolation
//a*(1-t) + b*t
inline float	fLerp  (const float& a,const float&b,const float &t){ return a + t * (b - a); }

inline float fWrap(float value, float base) {
    return (value<0) ? fmodf(value,base)+base : fmodf(value,base);
}


inline float    fDegree(float x,int y)
{
	int i;
	float kof=x;
	if(y==0)return 1;
	for(i=1;i<y;i++)
		x=x*kof;
	return x;
}
//factorial
inline DWORD64 Factorial(int i){
	int j;
	DWORD64 sum=1;
	for(j=1;j<i+1;j++)
		sum=sum*j;
	return sum;

}

inline float Bernstein(int L,int k,float t)
{
	return (Factorial(L)/(Factorial(k)*Factorial(L-k))*fDegree((1-t),L-k)*fDegree(t,k));
}

//deg x below y above


#endif


