#ifndef __MATH_3D__
#define __MATH_3D__

#include	"Math1D.h"
#include    "Types/Vector3D.h"
#include	"Types/Vector4D.h"
#include    <windows.h>

Vector3D    closestPointToSegment ( const Vector3D& p, const Vector3D& a, const Vector3D& b );
int			computeNearPointMask  ( const Vector3D& n );

inline float area ( const Vector3D& a, const Vector3D& b, const Vector3D& c )
{
    Vector3D v1 = b - a;
    Vector3D v2 = c - a;

    return ((v1.y*v2.z + v1.z*v2.x + v1.x*v2.y) - (v1.y*v2.x + v1.x*v2.z + v1.z*v2.y));
}

inline float intersectSphereByRay ( const Vector3D& center, float radius, const Vector3D& org, const Vector3D& dir )
{
    Vector3D q = center - org;
    float    c = q & q;             // squared length
    float    v = q & dir;
    float    d = radius * radius - (c * c - v* v);

    if ( d < 0.0f )
       return -1.0f;

    return (float)(v - sqrt ( d ));
}

Vector3D GetOGLPos(int x, int y);



inline Vector3D	fLerp  (const Vector3D& a,const Vector3D&b,const float &t){ return a + t * (b - a); }
inline Vector4D	fLerp  (const Vector4D& a,const Vector4D&b,const float &t){ return a + t * (b - a); }

inline Vector3D  GetRandomVector( void )
{

	Vector3D  vVector;

	// PIck a random Z between -1.0f and 1.0f.
	vVector.z = fRandom( -1.0f, 1.0f );

	// Get radius of this circle
	float radius = sqrtf(1 - vVector.z * vVector.z);


	// PIck a random point on a circle.
	float t = fRandom( -PI, PI );

	// Compute matching X and Y for our Z.
	vVector.x = cosf(t) * radius;
	vVector.y = sinf(t) * radius;

	return vVector;
}

#endif
