#ifndef __MATRIX4D__
#define __MATRIX4D__

#include "Vector4D.h"

class Matrix4D
{
public:
	float x [4][4];

	Matrix4D () {}
	Matrix4D ( float );
	Matrix4D ( const Matrix4D& );

	Matrix4D& operator =  ( const Matrix4D& );
	Matrix4D& operator =  ( float );
	Matrix4D& operator += ( const Matrix4D& );
	Matrix4D& operator -= ( const Matrix4D& );
	Matrix4D& operator *= ( const Matrix4D& );
	Matrix4D& operator *= ( float );
	Matrix4D& operator /= ( float );

	const float * operator [] ( int i ) const
	{
		return & x[i][0];
	}

	float * operator [] ( int i )
	{
		return & x[i][0];
	}

	Matrix4D&	invert    ();
	Matrix4D& 	transpose ();
	float		det       () const;

	Matrix4D	getInverse () const
	{
		return Matrix4D ( *this ).invert ();
	}
	
	//Picks values from m and transfers them to x[][]
	void		setMatrix(const float m[16]);
	//Picks values from x[][] and transfers them to m
	void		getMatrix( float m[16]);

	static	Matrix4D	getIdentityMatrix           ();

	friend Matrix4D operator + ( const Matrix4D&, const Matrix4D& );
	friend Matrix4D operator - ( const Matrix4D&, const Matrix4D& );
	friend Matrix4D operator * ( const Matrix4D&, const Matrix4D& );
	friend Matrix4D operator * ( const Matrix4D&, float );
	friend Matrix4D operator * ( float, const Matrix4D& );
	friend Vector4D operator * ( const Matrix4D&, const Vector4D& );
};

inline Vector4D operator * ( const Matrix4D& a, const Vector4D& b )
{
	return Vector4D ( a.x [0][0]*b.x + a.x [0][1]*b.y + a.x [0][2]*b.z + a.x [0][3]*b.w,
	                  a.x [1][0]*b.x + a.x [1][1]*b.y + a.x [1][2]*b.z + a.x [1][3]*b.w,
	                  a.x [2][0]*b.x + a.x [2][1]*b.y + a.x [2][2]*b.z + a.x [2][3]*b.w,
					  a.x [3][0]*b.x + a.x [3][1]*b.y + a.x [3][2]*b.z + a.x [3][3]*b.w);
}


#endif
