#ifndef __LINKEDLIST_HPP__
/* CPPDOC_BEGIN_EXCLUDE */
#define __LINKEDLIST_HPP__
/* CPPDOC_END_EXCLUDE */


#ifndef NULL
#define NULL 0
#endif
#include "ErrorCheck.h"

template <class ItemData> class LinkList;

/**
 * LinkedListItem saves data in LinkList.<br>
 * You can not create or delete LinkedListItem object. LinkList is responsible for that.<br>
 * To access item value read LinkedListItem::data.
 */
template <class ItemData> class LinkedListItem {
private:
    friend class LinkList<ItemData>;
    LinkedListItem<ItemData> *next;
    LinkedListItem(ItemData _data):next(NULL),data(_data) {} // empty body
    ~LinkedListItem() {} // empty body
public:
    /** value saved with this item */
    ItemData data;
};

/**
 * Helper class for a single-linked lists.<br>
 * You are free to use STL's list instead.
 */
template <class ItemData> class LinkList {
private:
    LinkedListItem<ItemData> *root;
    int cnt;

	void MergeSortArray(ItemData *ppSortBuffer, int nEntryCount, ItemData *ppTempBuffer){
		int nPart1Count = nEntryCount / 2;
		int nPart2Count = nEntryCount - nPart1Count;
		ItemData *ppBufferPart1 = ppSortBuffer;
		ItemData *ppBufferPart2 = &ppSortBuffer[nPart1Count];
		ItemData *ppTempBufferEntry = ppTempBuffer;
		int nCopyBackEntries = nEntryCount;

		if( nPart1Count >= 2 )
		{
			MergeSortArray( ppBufferPart1, nPart1Count, ppTempBuffer);
		}

		if( nPart2Count >= 2 )
		{
			MergeSortArray( ppBufferPart2, nPart2Count, ppTempBuffer);
		}

		if( (ppBufferPart1[nPart1Count-1])->IsRightOrder(*ppBufferPart2) ) /*pIsRightOrderFn( ppBufferPart1[nPart1Count - 1], *ppBufferPart2 ) )*/
		{
			// Both sorted parts are already sorted.
			return;
		}

		while( nPart1Count * nPart2Count > 0 )	// Same as while( (nPart1Count > 0) && (nPart2Count > 0) ).
		{
			if( (*ppBufferPart1)->IsRightOrder(*ppBufferPart2) ) /*pIsRightOrderFn( *ppBufferPart1, *ppBufferPart2 ) )*/
			{
				*ppTempBufferEntry++ = *ppBufferPart1++;
				--nPart1Count;
			}
			else
			{
				*ppTempBufferEntry++ = *ppBufferPart2++;
				--nPart2Count;
			}
		}

		while( nPart1Count > 0 )
		{
			*ppTempBufferEntry++ = *ppBufferPart1++;
			--nPart1Count;
		}

		nCopyBackEntries -= nPart2Count;	// There is no need to copy from second part to temp buffer, then later copy back to original place. Just skip coping.
		
		while( nCopyBackEntries-- > 0 )
		{
			*ppSortBuffer++ = *ppTempBuffer++;
		}
	}

public:
    /** Create LinkList object */
    LinkList():root(NULL),cnt(0) {}
    ~LinkList(){Clear();}

    /** 
     * Fast add element at the start of the list 
     * @param data value to add
     */
    void Add(ItemData data) {
        LinkedListItem<ItemData> *li = new LinkedListItem<ItemData>(data); 
        li->next = root; root = li; cnt++;
    }

	/**
     * Add element at the end of the list.<br>
     * Note: slow because causes running through the list to find last element.<br>
	 * @param data value to add
	 */
	void AddAtEnd(ItemData data){
		LinkedListItem<ItemData> *pcLastLi = root;
		if (pcLastLi == NULL)
			Add(data);
		else{
	        LinkedListItem<ItemData> *pcLi = new LinkedListItem<ItemData>(data); 
			//Traverse list to last element
			while(pcLastLi->next != NULL)
				pcLastLi = pcLastLi->next;

			pcLastLi->next = pcLi;
			cnt++;
		}
	}

    /**
     * Function to list all items.
     * Usage:<pre>
     * // LinkList&lt;type&gt; *list defined elsewhere
     * LinkedListItem&lt;type&gt; *li = list->Next(NULL); // access 1st element
     * while (li!=NULL) { // when li==NULL - all elements passed
     *     // do something with li->data
     *     ...
     *     // go to next element
     *     li = list->Next(li); 
     * }
     * </pre>
     * @param li LinkedListItem we want to obtain next element for. 
     * If NULL then 1st element will be returned.
     * @return LinkedListItem next to li in list. NULL if there's no such elements.
     */
    LinkedListItem<ItemData> *Next(LinkedListItem<ItemData> *li) {
        return (li==NULL) ? root : li->next;
    }

    /** Fast remove of the first element in list */
    void RemoveFirst() {
        if (root==NULL) return;
        LinkedListItem<ItemData> *li = root;
        root = root->next; cnt--;
         delete li;
    }

    /**
     * Remove first element with value equal to data parameter.<br>
     * Note: runs through the list while searching. O(N)
     * @param data value to search and remove
     */
    bool RemoveByValue(ItemData data) {
        LinkedListItem<ItemData> *li,*prevli;
        prevli = NULL; li = root;
        while (li!=NULL && li->data!=data) {
            prevli = li; li = li->next;
        }
        if (li==NULL) return false;
        if (prevli==NULL) 
            RemoveFirst(); //remove root
        else {
            prevli->next = li->next; cnt--; // remove from list
            delete li; // free memory
        }
        return true;
    }

	/**
	 * Return element with given value
	 * @param data value to search for
	 * @return LinkedListItem containing searched value, NULL if list contains no such
     * elements
	 */
	LinkedListItem<ItemData> *Find(ItemData data){
        LinkedListItem<ItemData> *li;
        li = root;
        while (li!=NULL && li->data!=data) {
            li = li->next;
        }

		return li;
	}

	/** Remove all elements from the list */
	void Clear(){
		int nTmpCnt = cnt;
		for(int i=0; i<nTmpCnt; i++)
			RemoveFirst();
	}

	void ClearData(){
		for(LinkedListItem<ItemData> *pItem = Next(NULL);
			pItem;
			pItem = Next(pItem))
		{
			delete pItem->data;
		}
	}

    /**
     * Return elements count
     * @return elements count
     */
    int Count() { return cnt; }

	/**
	 * Do a MergeSort. In order to work, list must contain pointers to objects and objects 
     * must have method IsRightOrder().<br>
     * Author: Denis Bolkovskis
	 */
	void MergeSort(){
		//ItemData cData = root->data;
		//cData->RightOrder();
		//root->data.RightOrder();
		
		if(cnt <= 1) return; //Nothing to sort :)
		//ItemData **ppSortBuffer = (ItemData**)malloc(sizeof(ItemData*) * cnt * 2);
		ItemData *ppSortBuffer = new ItemData[cnt * 2];
		ItemData *ppSortBufferEntry = ppSortBuffer;

		int i;
		for(i=0; i<cnt * 2; i++) 
			ppSortBuffer[i] = NULL;

		//Fill the sort buffer with objects
		LinkedListItem<ItemData> *pcLi = root;
		do{
			//ItemData cData = pcLi->data;
			*ppSortBufferEntry++ = pcLi->data;
			pcLi = pcLi->next;
		}while(pcLi != NULL);

		MergeSortArray(ppSortBuffer, cnt, ppSortBufferEntry);

		//Copy sorted pointers back to list
		ppSortBufferEntry = ppSortBuffer;
		pcLi = root;
		i = 0;
		do{
			pcLi->data = *ppSortBufferEntry++;
			pcLi = pcLi->next;
		}while(pcLi != NULL);

		delete [] ppSortBuffer;
	}
};

#include "NoMemoryMan.h"

#endif //__LINKEDLIST_HPP__

