/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.DRAWITEMSTRUCT;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

public class Label
extends Control {
    Image image;
    int font;
    static final int LabelProc;
    static final TCHAR LabelClass;

    static {
        LabelClass = new TCHAR(0, "STATIC", true);
        WNDCLASS lpWndClass = new WNDCLASS();
        OS.GetClassInfo(0, LabelClass, lpWndClass);
        LabelProc = lpWndClass.lpfnWndProc;
    }

    public Label(Composite parent, int style) {
        super(parent, Label.checkStyle(style));
    }

    int callWindowProc(int msg, int wParam, int lParam) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.CallWindowProc(LabelProc, this.handle, msg, wParam, lParam);
    }

    static int checkStyle(int style) {
        if ((style & 2) != 0) {
            style = Widget.checkBits(style, 512, 256, 0, 0, 0, 0);
            return Widget.checkBits(style, 8, 4, 32, 0, 0, 0);
        }
        return Widget.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        boolean isIcon;
        this.checkWidget();
        int width = 0;
        int height = 0;
        int border = this.getBorderWidth();
        if ((this.style & 2) != 0) {
            int lineWidth = OS.GetSystemMetrics(5);
            if ((this.style & 0x100) != 0) {
                width = 64;
                height = lineWidth * 2;
            } else {
                width = lineWidth * 2;
                height = 64;
            }
            if (wHint != -1) {
                width = wHint;
            }
            if (hHint != -1) {
                height = hHint;
            }
            return new Point(width += border * 2, height += border * 2);
        }
        int bits = OS.GetWindowLong(this.handle, -16);
        boolean isBitmap = (bits & 0xE) == 14;
        boolean bl = isIcon = (bits & 3) == 3;
        if (isBitmap || isIcon) {
            if (this.image != null) {
                Rectangle rect = this.image.getBounds();
                width = rect.width;
                height = rect.height;
            }
        } else {
            int hDC = OS.GetDC(this.handle);
            int newFont = OS.SendMessage(this.handle, 49, 0, 0);
            int oldFont = OS.SelectObject(hDC, newFont);
            RECT rect = new RECT();
            int flags = 9280;
            if ((this.style & 0x40) != 0 && wHint != -1) {
                flags |= 0x10;
                rect.right = wHint;
            }
            int length = OS.GetWindowTextLength(this.handle);
            TCHAR buffer = new TCHAR(this.getCodePage(), length + 1);
            OS.GetWindowText(this.handle, buffer, length + 1);
            OS.DrawText(hDC, buffer, length, rect, flags);
            width = rect.right - rect.left;
            height = rect.bottom - rect.top;
            if (height == 0) {
                TEXTMETRIC tm = new TEXTMETRIC();
                OS.GetTextMetrics(hDC, tm);
                height = tm.tmHeight;
            }
            if (newFont != 0) {
                OS.SelectObject(hDC, oldFont);
            }
            OS.ReleaseDC(this.handle, hDC);
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        width += border * 2;
        height += border * 2;
        if (OS.IsWinCE && !isBitmap && !isIcon) {
            width += 2;
        }
        return new Point(width, height);
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return 0;
        }
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return "";
        }
        int length = OS.GetWindowTextLength(this.handle);
        if (length == 0) {
            return "";
        }
        TCHAR buffer = new TCHAR(this.getCodePage(), length + 1);
        OS.GetWindowText(this.handle, buffer, length + 1);
        return buffer.toString(0, length);
    }

    boolean getWrap() {
        int bits = OS.GetWindowLong(this.handle, -16);
        if ((bits & 3) != 0) {
            return true;
        }
        return (bits & 0xC) == 0;
    }

    boolean mnemonicHit(char key) {
        Composite control = this.parent;
        while (control != null) {
            Control[] children = control._getChildren();
            int index = 0;
            while (index < children.length) {
                if (children[index] == this) break;
                ++index;
            }
            if (++index < children.length && children[index].setFocus()) {
                return true;
            }
            control = control.parent;
        }
        return false;
    }

    boolean mnemonicMatch(char key) {
        char mnemonic = this.findMnemonic(this.getText());
        if (mnemonic == '\u0000') {
            return false;
        }
        return Character.toUpperCase(key) == Character.toUpperCase(mnemonic);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.image = null;
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= alignment & 0x1024000;
        int bits = OS.GetWindowLong(this.handle, -16);
        if ((bits & 0xE) == 14) {
            return;
        }
        if ((bits & 3) == 3) {
            return;
        }
        bits &= 0xFFFFFFF0;
        if ((this.style & 0x4000) != 0 && (this.style & 0x40) == 0) {
            bits |= 0xC;
        }
        if ((this.style & 0x1000000) != 0) {
            bits |= 1;
        }
        if ((this.style & 0x20000) != 0) {
            bits |= 2;
        }
        OS.SetWindowLong(this.handle, -16, bits);
        OS.InvalidateRect(this.handle, null, true);
    }

    public boolean setFocus() {
        this.checkWidget();
        return false;
    }

    public void setImage(Image image) {
        int newBits;
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        int hImage = 0;
        int imageBits = 0;
        int fImageType = 0;
        if (image != null) {
            if (image.isDisposed()) {
                this.error(5);
            }
            hImage = image.handle;
            switch (image.type) {
                case 0: {
                    imageBits = 14;
                    fImageType = 0;
                    break;
                }
                case 1: {
                    imageBits = 3;
                    fImageType = 1;
                    break;
                }
                default: {
                    return;
                }
            }
        }
        this.image = image;
        RECT rect = new RECT();
        OS.GetWindowRect(this.handle, rect);
        int oldBits = newBits = OS.GetWindowLong(this.handle, -16);
        newBits &= 0xFFFFFFF0;
        if ((newBits |= imageBits | 0x800 | 0x200) != oldBits) {
            OS.SetWindowLong(this.handle, -16, newBits);
        }
        OS.SendMessage(this.handle, 370, fImageType, hImage);
        int flags = 54;
        OS.SetWindowPos(this.handle, 0, 0, 0, rect.right - rect.left, rect.bottom - rect.top, flags);
        OS.InvalidateRect(this.handle, null, true);
    }

    public void setText(String string) {
        int newBits;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        int oldBits = newBits = OS.GetWindowLong(this.handle, -16);
        newBits &= 0xFFFFF5F0;
        if ((this.style & 0x4000) != 0 && (this.style & 0x40) == 0) {
            newBits |= 0xC;
        }
        if ((this.style & 0x1000000) != 0) {
            newBits |= 1;
        }
        if ((this.style & 0x20000) != 0) {
            newBits |= 2;
        }
        if (newBits != oldBits) {
            int hFont = OS.SendMessage(this.handle, 49, 0, 0);
            OS.SetWindowLong(this.handle, -16, newBits);
            if (hFont != 0) {
                OS.SendMessage(this.handle, 48, hFont, 0);
            }
        }
        string = Display.withCrLf(string);
        TCHAR buffer = new TCHAR(this.getCodePage(), string, true);
        OS.SetWindowText(this.handle, buffer);
    }

    void setWrap(boolean wrap) {
        int bits = OS.GetWindowLong(this.handle, -16);
        if ((bits & 3) != 0) {
            return;
        }
        bits &= 0xFFFFFFF3;
        if (!wrap) {
            bits |= 0xC;
        }
        OS.SetWindowLong(this.handle, -16, bits);
        OS.InvalidateRect(this.handle, null, true);
    }

    int widgetExtStyle() {
        int bits = super.widgetExtStyle() & 0xFFFFFDFF;
        if ((this.style & 0x800) != 0) {
            return bits | 0x20000;
        }
        return bits;
    }

    int widgetStyle() {
        int bits = super.widgetStyle() | 0x100;
        if ((this.style & 2) != 0) {
            return bits | 0xD;
        }
        if ((this.style & 0x1000000) != 0) {
            return bits | 1;
        }
        if ((this.style & 0x20000) != 0) {
            return bits | 2;
        }
        if ((this.style & 0x40) != 0) {
            return bits;
        }
        return bits | 0xC;
    }

    TCHAR windowClass() {
        return LabelClass;
    }

    int windowProc() {
        return LabelProc;
    }

    LRESULT WM_ERASEBKGND(int wParam, int lParam) {
        boolean isIcon;
        LRESULT result = super.WM_ERASEBKGND(wParam, lParam);
        if (result != null) {
            return result;
        }
        if ((this.style & 2) != 0) {
            return LRESULT.ONE;
        }
        int bits = OS.GetWindowLong(this.handle, -16);
        boolean isBitmap = (bits & 0xE) == 14;
        boolean bl = isIcon = (bits & 3) == 3;
        if (isBitmap || isIcon) {
            this.drawBackground(wParam);
            return LRESULT.ONE;
        }
        return result;
    }

    LRESULT WM_GETFONT(int wParam, int lParam) {
        LRESULT result = super.WM_GETFONT(wParam, lParam);
        if (result != null) {
            return result;
        }
        if (this.font == 0) {
            this.font = this.defaultFont();
        }
        return new LRESULT(this.font);
    }

    LRESULT WM_SETFONT(int wParam, int lParam) {
        this.font = wParam;
        return super.WM_SETFONT(this.font, lParam);
    }

    LRESULT WM_SIZE(int wParam, int lParam) {
        boolean isIcon;
        LRESULT result = super.WM_SIZE(wParam, lParam);
        if (this.isDisposed()) {
            return result;
        }
        if ((this.style & 2) != 0) {
            OS.InvalidateRect(this.handle, null, true);
            return result;
        }
        int bits = OS.GetWindowLong(this.handle, -16);
        boolean isBitmap = (bits & 0xE) == 14;
        boolean bl = isIcon = (bits & 3) == 3;
        if (isBitmap || isIcon) {
            OS.InvalidateRect(this.handle, null, true);
            return result;
        }
        if ((this.style & 0x1020040) != 0) {
            OS.InvalidateRect(this.handle, null, true);
            return result;
        }
        return result;
    }

    LRESULT wmDrawChild(int wParam, int lParam) {
        DRAWITEMSTRUCT struct = new DRAWITEMSTRUCT();
        OS.MoveMemory(struct, lParam, 48);
        this.drawBackground(struct.hDC);
        if ((this.style & 0x20) != 0) {
            return null;
        }
        RECT rect = new RECT();
        int lineWidth = OS.GetSystemMetrics(5);
        int flags = 6;
        if ((this.style & 4) != 0) {
            flags = 10;
        }
        if ((this.style & 0x100) != 0) {
            int bottom = struct.top + Math.max(lineWidth * 2, (struct.bottom - struct.top) / 2);
            OS.SetRect(rect, struct.left, struct.top, struct.right, bottom);
            OS.DrawEdge(struct.hDC, rect, flags, 8);
        } else {
            int right = struct.left + Math.max(lineWidth * 2, (struct.right - struct.left) / 2);
            OS.SetRect(rect, struct.left, struct.top, right, struct.bottom);
            OS.DrawEdge(struct.hDC, rect, flags, 4);
        }
        return null;
    }
}

