/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.opengl;

import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.opengl.GL;
import org.eclipse.swt.opengl.GLU;
import org.eclipse.swt.opengl.GLYPHMETRICSFLOAT;
import org.eclipse.swt.opengl.ImageDataUtil;
import org.eclipse.swt.opengl.internal.win32.PIXELFORMATDESCRIPTOR;
import org.eclipse.swt.opengl.internal.win32.WGL;

public class GLContext {
    int handle;
    int hDC;
    GCData data;
    Drawable drawable;
    int selectBufferPtr = 0;
    static final int MSB_FIRST = 1;
    static final int LSB_FIRST = 2;

    public GLContext(Drawable drawable) {
        if (drawable == null) {
            SWT.error((int)4);
        }
        this.drawable = drawable;
        this.data = new GCData();
        this.hDC = drawable.internal_new_GC(this.data);
        if (this.hDC == 0) {
            SWT.error((int)2);
        }
        int bits = OS.GetDeviceCaps((int)this.hDC, (int)12);
        int planes = OS.GetDeviceCaps((int)this.hDC, (int)14);
        int depth = bits * planes;
        PIXELFORMATDESCRIPTOR pfd = new PIXELFORMATDESCRIPTOR();
        pfd.nSize = (short)40;
        pfd.nVersion = 1;
        pfd.dwFlags = 37;
        pfd.dwLayerMask = 0;
        pfd.iPixelType = 0;
        pfd.cColorBits = (byte)depth;
        pfd.cDepthBits = (byte)depth;
        pfd.cAccumBits = 0;
        pfd.cStencilBits = 0;
        int pixelFormat = WGL.ChoosePixelFormat(this.hDC, pfd);
        if (pixelFormat == 0) {
            drawable.internal_dispose_GC(this.hDC, this.data);
            SWT.error((int)38);
        }
        if (!WGL.SetPixelFormat(this.hDC, pixelFormat, pfd)) {
            drawable.internal_dispose_GC(this.hDC, this.data);
            SWT.error((int)38);
        }
        this.handle = WGL.wglCreateContext(this.hDC);
        if (this.handle == 0) {
            SWT.error((int)2);
        }
    }

    public ImageData convertImageData(ImageData source) {
        PaletteData palette = new PaletteData(0xFF0000, 65280, 255);
        ImageData newSource = new ImageData(source.width, source.height, 24, palette);
        ImageDataUtil.blit(1, source.data, source.depth, source.bytesPerLine, source.depth != 16 ? 1 : 2, 0, 0, source.width, source.height, source.palette.redMask, source.palette.greenMask, source.palette.blueMask, 255, null, 0, 0, 0, newSource.data, newSource.depth, newSource.bytesPerLine, newSource.depth != 16 ? 1 : 2, 0, 0, newSource.width, newSource.height, newSource.palette.redMask, newSource.palette.greenMask, newSource.palette.blueMask, false, true);
        return newSource;
    }

    public void dispose() {
        if (this.handle == 0) {
            return;
        }
        if (WGL.wglGetCurrentContext() == this.handle) {
            WGL.wglMakeCurrent(0, 0);
        }
        WGL.wglDeleteContext(this.handle);
        this.handle = 0;
        try {
            this.drawable.internal_dispose_GC(this.hDC, this.data);
        }
        catch (SWTException sWTException) {}
        int hHeap = OS.GetProcessHeap();
        if (this.selectBufferPtr != 0) {
            OS.HeapFree((int)hHeap, (int)0, (int)this.selectBufferPtr);
        }
        this.hDC = 0;
        this.drawable = null;
        this.data.device = null;
        this.data = null;
    }

    public int[] getSelectBuffer(int selectBufferPtr, int[] selectBuffer) {
        OS.MoveMemory((int[])selectBuffer, (int)selectBufferPtr, (int)(selectBuffer.length * 4));
        return selectBuffer;
    }

    public int getSelectBufferPtr(int[] selectBuffer) {
        if (this.selectBufferPtr == 0) {
            int hHeap = OS.GetProcessHeap();
            this.selectBufferPtr = OS.HeapAlloc((int)hHeap, (int)8, (int)(selectBuffer.length * 4));
        }
        OS.MoveMemory((int)this.selectBufferPtr, (int[])selectBuffer, (int)(selectBuffer.length * 4));
        return this.selectBufferPtr;
    }

    public boolean isCurrent() {
        if (this.isDisposed()) {
            SWT.error((int)44);
        }
        return WGL.wglGetCurrentContext() == this.handle;
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public void loadBitmapFont(FontData fdata, Device device, int base, int first, int count) {
        Font font = new Font(device, fdata);
        int oldFont = OS.SelectObject((int)this.hDC, (int)font.handle);
        WGL.wglUseFontBitmaps(this.hDC, first, count, base);
        OS.SelectObject((int)this.hDC, (int)oldFont);
        font.dispose();
    }

    public void loadOutlineFont(FontData fdata, Device device, int base, int first, int count, float deviation, float extrusion, int format, GLYPHMETRICSFLOAT[] lpgmf) {
        int ptr = 0;
        int hHeap = 0;
        if (lpgmf != null && lpgmf.length == count + 1) {
            hHeap = OS.GetProcessHeap();
            ptr = OS.HeapAlloc((int)hHeap, (int)8, (int)(count * 24));
        }
        if (format == 9) {
            format = 1;
        }
        if (format == 6913) {
            format = 0;
        }
        Font font = new Font(device, fdata);
        int oldFont = OS.SelectObject((int)this.hDC, (int)font.handle);
        WGL.wglUseFontOutlines(this.hDC, first, count, base, deviation, extrusion, format, ptr);
        OS.SelectObject((int)this.hDC, (int)oldFont);
        font.dispose();
        if (ptr != 0) {
            int sizeof = 24;
            int i = 0;
            while (i < lpgmf.length) {
                WGL.MoveMemory(lpgmf[i], ptr + sizeof * i, sizeof);
                ++i;
            }
            OS.HeapFree((int)hHeap, (int)0, (int)ptr);
        }
    }

    public void resize(int x, int y, int width, int height) {
        if (height == 0) {
            height = 1;
        }
        GL.glViewport(0, 0, width, height);
        GL.glMatrixMode(5889);
        GL.glLoadIdentity();
        GLU.gluPerspective(45.0, (float)width / (float)height, 0.1f, 100.0);
        GL.glMatrixMode(5888);
        GL.glLoadIdentity();
    }

    public void setCurrent() {
        if (this.isDisposed()) {
            SWT.error((int)44);
        }
        if (WGL.wglGetCurrentContext() == this.handle) {
            return;
        }
        WGL.wglMakeCurrent(this.hDC, this.handle);
    }

    public void swapBuffers() {
        if (this.isDisposed()) {
            SWT.error((int)44);
        }
        WGL.SwapBuffers(this.hDC);
    }
}

