/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.opengl;

public class ImageDataUtil {
    static final int ALPHA_OPAQUE = 255;
    static final int ALPHA_TRANSPARENT = 0;
    static final int ALPHA_CHANNEL_SEPARATE = -1;
    static final int ALPHA_CHANNEL_SOURCE = -2;
    static final int ALPHA_MASK_UNPACKED = -3;
    static final int ALPHA_MASK_PACKED = -4;
    static final int ALPHA_MASK_INDEX = -5;
    static final int ALPHA_MASK_RGB = -6;
    private static final int TYPE_GENERIC_8 = 0;
    private static final int TYPE_GENERIC_16_MSB = 1;
    private static final int TYPE_GENERIC_16_LSB = 2;
    private static final int TYPE_GENERIC_24 = 3;
    private static final int TYPE_GENERIC_32_MSB = 4;
    private static final int TYPE_GENERIC_32_LSB = 5;
    private static final int TYPE_INDEX_8 = 6;
    private static final int TYPE_INDEX_4 = 7;
    private static final int TYPE_INDEX_2 = 8;
    private static final int TYPE_INDEX_1_MSB = 9;
    private static final int TYPE_INDEX_1_LSB = 10;
    static final int LSB_FIRST = 0;
    static final int MSB_FIRST = 1;
    static final int BLIT_SRC = 1;
    static final int BLIT_ALPHA = 2;
    static final int BLIT_DITHER = 4;
    static final byte[][] ANY_TO_EIGHT = new byte[9][];

    static {
        int b = 0;
        while (b < 9) {
            ImageDataUtil.ANY_TO_EIGHT[b] = new byte[1 << b];
            byte[] data = ImageDataUtil.ANY_TO_EIGHT[b];
            if (b != 0) {
                int inc = 0;
                int bit = 65536;
                while ((bit >>= b) != 0) {
                    inc |= bit;
                }
                int v = 0;
                int p = 0;
                while (v < 65536) {
                    data[p++] = (byte)(v >> 8);
                    v += inc;
                }
            }
            ++b;
        }
    }

    static void blit(int op, byte[] srcData, int srcDepth, int srcStride, int srcOrder, int srcX, int srcY, int srcWidth, int srcHeight, int srcRedMask, int srcGreenMask, int srcBlueMask, int alphaMode, byte[] alphaData, int alphaStride, int alphaX, int alphaY, byte[] destData, int destDepth, int destStride, int destOrder, int destX, int destY, int destWidth, int destHeight, int destRedMask, int destGreenMask, int destBlueMask, boolean flipX, boolean flipY) {
        int apr;
        int dpryi;
        int dtype;
        int dbpp;
        int stype;
        int sbpp;
        if (destWidth <= 0 || destHeight <= 0 || alphaMode == 0) {
            return;
        }
        int dwm1 = destWidth - 1;
        int sfxi = dwm1 != 0 ? (int)((((long)srcWidth << 16) - 1L) / (long)dwm1) : 0;
        int dhm1 = destHeight - 1;
        int sfyi = dhm1 != 0 ? (int)((((long)srcHeight << 16) - 1L) / (long)dhm1) : 0;
        switch (srcDepth) {
            case 8: {
                sbpp = 1;
                stype = 0;
                break;
            }
            case 16: {
                sbpp = 2;
                stype = srcOrder == 1 ? 1 : 2;
                break;
            }
            case 24: {
                sbpp = 3;
                stype = 3;
                break;
            }
            case 32: {
                sbpp = 4;
                stype = srcOrder == 1 ? 4 : 5;
                break;
            }
            default: {
                return;
            }
        }
        int spr = srcY * srcStride + srcX * sbpp;
        switch (destDepth) {
            case 8: {
                dbpp = 1;
                dtype = 0;
                break;
            }
            case 16: {
                dbpp = 2;
                dtype = destOrder == 1 ? 1 : 2;
                break;
            }
            case 24: {
                dbpp = 3;
                dtype = 3;
                break;
            }
            case 32: {
                dbpp = 4;
                dtype = destOrder == 1 ? 4 : 5;
                break;
            }
            default: {
                return;
            }
        }
        int dpr = (flipY ? destY + dhm1 : destY) * destStride + (flipX ? destX + dwm1 : destX) * dbpp;
        int dprxi = flipX ? -dbpp : dbpp;
        int n = dpryi = flipY ? -destStride : destStride;
        if ((op & 2) != 0) {
            switch (alphaMode) {
                case -3: 
                case -1: {
                    if (alphaData == null) {
                        alphaMode = 65536;
                    }
                    apr = alphaY * alphaStride + alphaX;
                    break;
                }
                case -4: {
                    if (alphaData == null) {
                        alphaMode = 65536;
                    }
                    apr = alphaY * (alphaStride <<= 3) + alphaX;
                    break;
                }
                case -5: {
                    return;
                }
                case -6: {
                    if (alphaData == null) {
                        alphaMode = 65536;
                    }
                    apr = 0;
                    break;
                }
                default: {
                    alphaMode = (alphaMode << 16) / 255;
                }
                case -2: {
                    apr = 0;
                    break;
                }
            }
        } else {
            alphaMode = 65536;
            apr = 0;
        }
        int dp = dpr;
        int sp = spr;
        if (alphaMode == 65536 && stype == dtype && srcRedMask == destRedMask && srcGreenMask == destGreenMask && srcBlueMask == destBlueMask) {
            switch (sbpp) {
                case 1: {
                    int dy = destHeight;
                    int sfy = sfyi;
                    while (dy > 0) {
                        int dx = destWidth;
                        int sfx = sfxi;
                        while (dx > 0) {
                            destData[dp] = srcData[sp];
                            sp += sfx >>> 16;
                            --dx;
                            dp += dprxi;
                            sfx = (sfx & 0xFFFF) + sfxi;
                        }
                        --dy;
                        sp = spr += (sfy >>> 16) * srcStride;
                        sfy = (sfy & 0xFFFF) + sfyi;
                        dp = dpr += dpryi;
                    }
                    break;
                }
                case 2: {
                    int dy = destHeight;
                    int sfy = sfyi;
                    while (dy > 0) {
                        int dx = destWidth;
                        int sfx = sfxi;
                        while (dx > 0) {
                            destData[dp] = srcData[sp];
                            destData[dp + 1] = srcData[sp + 1];
                            sp += (sfx >>> 16) * 2;
                            --dx;
                            dp += dprxi;
                            sfx = (sfx & 0xFFFF) + sfxi;
                        }
                        --dy;
                        sp = spr += (sfy >>> 16) * srcStride;
                        sfy = (sfy & 0xFFFF) + sfyi;
                        dp = dpr += dpryi;
                    }
                    break;
                }
                case 3: {
                    int dy = destHeight;
                    int sfy = sfyi;
                    while (dy > 0) {
                        int dx = destWidth;
                        int sfx = sfxi;
                        while (dx > 0) {
                            destData[dp] = srcData[sp];
                            destData[dp + 1] = srcData[sp + 1];
                            destData[dp + 2] = srcData[sp + 2];
                            sp += (sfx >>> 16) * 3;
                            --dx;
                            dp += dprxi;
                            sfx = (sfx & 0xFFFF) + sfxi;
                        }
                        --dy;
                        sp = spr += (sfy >>> 16) * srcStride;
                        sfy = (sfy & 0xFFFF) + sfyi;
                        dp = dpr += dpryi;
                    }
                    break;
                }
                case 4: {
                    int dy = destHeight;
                    int sfy = sfyi;
                    while (dy > 0) {
                        int dx = destWidth;
                        int sfx = sfxi;
                        while (dx > 0) {
                            destData[dp] = srcData[sp];
                            destData[dp + 1] = srcData[sp + 1];
                            destData[dp + 2] = srcData[sp + 2];
                            destData[dp + 3] = srcData[sp + 3];
                            sp += (sfx >>> 16) * 4;
                            --dx;
                            dp += dprxi;
                            sfx = (sfx & 0xFFFF) + sfxi;
                        }
                        --dy;
                        sp = spr += (sfy >>> 16) * srcStride;
                        sfy = (sfy & 0xFFFF) + sfyi;
                        dp = dpr += dpryi;
                    }
                    break;
                }
            }
            return;
        }
        int srcRedShift = ImageDataUtil.getChannelShift(srcRedMask);
        byte[] srcReds = ANY_TO_EIGHT[ImageDataUtil.getChannelWidth(srcRedMask, srcRedShift)];
        int srcGreenShift = ImageDataUtil.getChannelShift(srcGreenMask);
        byte[] srcGreens = ANY_TO_EIGHT[ImageDataUtil.getChannelWidth(srcGreenMask, srcGreenShift)];
        int srcBlueShift = ImageDataUtil.getChannelShift(srcBlueMask);
        byte[] srcBlues = ANY_TO_EIGHT[ImageDataUtil.getChannelWidth(srcBlueMask, srcBlueShift)];
        int srcAlphaShift = ImageDataUtil.getChannelShift(0);
        byte[] srcAlphas = ANY_TO_EIGHT[ImageDataUtil.getChannelWidth(0, srcAlphaShift)];
        int destRedShift = ImageDataUtil.getChannelShift(destRedMask);
        int destRedWidth = ImageDataUtil.getChannelWidth(destRedMask, destRedShift);
        byte[] destReds = ANY_TO_EIGHT[destRedWidth];
        int destRedPreShift = 8 - destRedWidth;
        int destGreenShift = ImageDataUtil.getChannelShift(destGreenMask);
        int destGreenWidth = ImageDataUtil.getChannelWidth(destGreenMask, destGreenShift);
        byte[] destGreens = ANY_TO_EIGHT[destGreenWidth];
        int destGreenPreShift = 8 - destGreenWidth;
        int destBlueShift = ImageDataUtil.getChannelShift(destBlueMask);
        int destBlueWidth = ImageDataUtil.getChannelWidth(destBlueMask, destBlueShift);
        byte[] destBlues = ANY_TO_EIGHT[destBlueWidth];
        int destBluePreShift = 8 - destBlueWidth;
        int destAlphaShift = ImageDataUtil.getChannelShift(0);
        int destAlphaWidth = ImageDataUtil.getChannelWidth(0, destAlphaShift);
        byte[] destAlphas = ANY_TO_EIGHT[destAlphaWidth];
        int destAlphaPreShift = 8 - destAlphaWidth;
        int ap = apr;
        int alpha = alphaMode;
        int r = 0;
        int g = 0;
        int b = 0;
        int a = 0;
        int rq = 0;
        int gq = 0;
        int bq = 0;
        int aq = 0;
        int dy = destHeight;
        int sfy = sfyi;
        while (dy > 0) {
            int dx = destWidth;
            int sfx = sfxi;
            while (dx > 0) {
                block79: {
                    int data;
                    block78: {
                        switch (stype) {
                            case 0: {
                                data = srcData[sp] & 0xFF;
                                sp += sfx >>> 16;
                                r = srcReds[(data & srcRedMask) >>> srcRedShift] & 0xFF;
                                g = srcGreens[(data & srcGreenMask) >>> srcGreenShift] & 0xFF;
                                b = srcBlues[(data & srcBlueMask) >>> srcBlueShift] & 0xFF;
                                a = srcAlphas[0 >>> srcAlphaShift] & 0xFF;
                                break;
                            }
                            case 1: {
                                data = (srcData[sp] & 0xFF) << 8 | srcData[sp + 1] & 0xFF;
                                sp += (sfx >>> 16) * 2;
                                r = srcReds[(data & srcRedMask) >>> srcRedShift] & 0xFF;
                                g = srcGreens[(data & srcGreenMask) >>> srcGreenShift] & 0xFF;
                                b = srcBlues[(data & srcBlueMask) >>> srcBlueShift] & 0xFF;
                                a = srcAlphas[0 >>> srcAlphaShift] & 0xFF;
                                break;
                            }
                            case 2: {
                                data = (srcData[sp + 1] & 0xFF) << 8 | srcData[sp] & 0xFF;
                                sp += (sfx >>> 16) * 2;
                                r = srcReds[(data & srcRedMask) >>> srcRedShift] & 0xFF;
                                g = srcGreens[(data & srcGreenMask) >>> srcGreenShift] & 0xFF;
                                b = srcBlues[(data & srcBlueMask) >>> srcBlueShift] & 0xFF;
                                a = srcAlphas[0 >>> srcAlphaShift] & 0xFF;
                                break;
                            }
                            case 3: {
                                data = ((srcData[sp] & 0xFF) << 8 | srcData[sp + 1] & 0xFF) << 8 | srcData[sp + 2] & 0xFF;
                                sp += (sfx >>> 16) * 3;
                                r = srcReds[(data & srcRedMask) >>> srcRedShift] & 0xFF;
                                g = srcGreens[(data & srcGreenMask) >>> srcGreenShift] & 0xFF;
                                b = srcBlues[(data & srcBlueMask) >>> srcBlueShift] & 0xFF;
                                a = srcAlphas[0 >>> srcAlphaShift] & 0xFF;
                                break;
                            }
                            case 4: {
                                data = (((srcData[sp] & 0xFF) << 8 | srcData[sp + 1] & 0xFF) << 8 | srcData[sp + 2] & 0xFF) << 8 | srcData[sp + 3] & 0xFF;
                                sp += (sfx >>> 16) * 4;
                                r = srcReds[(data & srcRedMask) >>> srcRedShift] & 0xFF;
                                g = srcGreens[(data & srcGreenMask) >>> srcGreenShift] & 0xFF;
                                b = srcBlues[(data & srcBlueMask) >>> srcBlueShift] & 0xFF;
                                a = srcAlphas[0 >>> srcAlphaShift] & 0xFF;
                                break;
                            }
                            case 5: {
                                data = (((srcData[sp + 3] & 0xFF) << 8 | srcData[sp + 2] & 0xFF) << 8 | srcData[sp + 1] & 0xFF) << 8 | srcData[sp] & 0xFF;
                                sp += (sfx >>> 16) * 4;
                                r = srcReds[(data & srcRedMask) >>> srcRedShift] & 0xFF;
                                g = srcGreens[(data & srcGreenMask) >>> srcGreenShift] & 0xFF;
                                b = srcBlues[(data & srcBlueMask) >>> srcBlueShift] & 0xFF;
                                a = srcAlphas[0 >>> srcAlphaShift] & 0xFF;
                            }
                        }
                        block33 : switch (alphaMode) {
                            case -1: {
                                alpha = ((alphaData[ap] & 0xFF) << 16) / 255;
                                ap += sfx >> 16;
                                break;
                            }
                            case -2: {
                                alpha = (a << 16) / 255;
                                break;
                            }
                            case -3: {
                                alpha = alphaData[ap] != 0 ? 65536 : 0;
                                ap += sfx >> 16;
                                break;
                            }
                            case -4: {
                                alpha = alphaData[ap >> 3] << (ap & 7) + 9 & 0x10000;
                                ap += sfx >> 16;
                                break;
                            }
                            case -6: {
                                alpha = 65536;
                                int i = 0;
                                while (i < alphaData.length) {
                                    if (r == alphaData[i] && g == alphaData[i + 1] && b == alphaData[i + 2]) {
                                        alpha = 0;
                                        break block33;
                                    }
                                    i += 3;
                                }
                                break;
                            }
                        }
                        if (alpha == 65536) break block78;
                        if (alpha == 0) break block79;
                        switch (dtype) {
                            case 0: {
                                data = destData[dp] & 0xFF;
                                rq = destReds[(data & destRedMask) >>> destRedShift] & 0xFF;
                                gq = destGreens[(data & destGreenMask) >>> destGreenShift] & 0xFF;
                                bq = destBlues[(data & destBlueMask) >>> destBlueShift] & 0xFF;
                                aq = destAlphas[0 >>> destAlphaShift] & 0xFF;
                                break;
                            }
                            case 1: {
                                data = (destData[dp] & 0xFF) << 8 | destData[dp + 1] & 0xFF;
                                rq = destReds[(data & destRedMask) >>> destRedShift] & 0xFF;
                                gq = destGreens[(data & destGreenMask) >>> destGreenShift] & 0xFF;
                                bq = destBlues[(data & destBlueMask) >>> destBlueShift] & 0xFF;
                                aq = destAlphas[0 >>> destAlphaShift] & 0xFF;
                                break;
                            }
                            case 2: {
                                data = (destData[dp + 1] & 0xFF) << 8 | destData[dp] & 0xFF;
                                rq = destReds[(data & destRedMask) >>> destRedShift] & 0xFF;
                                gq = destGreens[(data & destGreenMask) >>> destGreenShift] & 0xFF;
                                bq = destBlues[(data & destBlueMask) >>> destBlueShift] & 0xFF;
                                aq = destAlphas[0 >>> destAlphaShift] & 0xFF;
                                break;
                            }
                            case 3: {
                                data = ((destData[dp] & 0xFF) << 8 | destData[dp + 1] & 0xFF) << 8 | destData[dp + 2] & 0xFF;
                                rq = destReds[(data & destRedMask) >>> destRedShift] & 0xFF;
                                gq = destGreens[(data & destGreenMask) >>> destGreenShift] & 0xFF;
                                bq = destBlues[(data & destBlueMask) >>> destBlueShift] & 0xFF;
                                aq = destAlphas[0 >>> destAlphaShift] & 0xFF;
                                break;
                            }
                            case 4: {
                                data = (((destData[dp] & 0xFF) << 8 | destData[dp + 1] & 0xFF) << 8 | destData[dp + 2] & 0xFF) << 8 | destData[dp + 3] & 0xFF;
                                rq = destReds[(data & destRedMask) >>> destRedShift] & 0xFF;
                                gq = destGreens[(data & destGreenMask) >>> destGreenShift] & 0xFF;
                                bq = destBlues[(data & destBlueMask) >>> destBlueShift] & 0xFF;
                                aq = destAlphas[0 >>> destAlphaShift] & 0xFF;
                                break;
                            }
                            case 5: {
                                data = (((destData[dp + 3] & 0xFF) << 8 | destData[dp + 2] & 0xFF) << 8 | destData[dp + 1] & 0xFF) << 8 | destData[dp] & 0xFF;
                                rq = destReds[(data & destRedMask) >>> destRedShift] & 0xFF;
                                gq = destGreens[(data & destGreenMask) >>> destGreenShift] & 0xFF;
                                bq = destBlues[(data & destBlueMask) >>> destBlueShift] & 0xFF;
                                aq = destAlphas[0 >>> destAlphaShift] & 0xFF;
                            }
                        }
                        a = aq + ((a - aq) * alpha >> 16);
                        r = rq + ((r - rq) * alpha >> 16);
                        g = gq + ((g - gq) * alpha >> 16);
                        b = bq + ((b - bq) * alpha >> 16);
                    }
                    data = r >>> destRedPreShift << destRedShift | g >>> destGreenPreShift << destGreenShift | b >>> destBluePreShift << destBlueShift | a >>> destAlphaPreShift << destAlphaShift;
                    switch (dtype) {
                        case 0: {
                            destData[dp] = (byte)data;
                            break;
                        }
                        case 1: {
                            destData[dp] = (byte)(data >>> 8);
                            destData[dp + 1] = (byte)(data & 0xFF);
                            break;
                        }
                        case 2: {
                            destData[dp] = (byte)(data & 0xFF);
                            destData[dp + 1] = (byte)(data >>> 8);
                            break;
                        }
                        case 3: {
                            destData[dp] = (byte)(data >>> 16);
                            destData[dp + 1] = (byte)(data >>> 8);
                            destData[dp + 2] = (byte)(data & 0xFF);
                            break;
                        }
                        case 4: {
                            destData[dp] = (byte)(data >>> 24);
                            destData[dp + 1] = (byte)(data >>> 16);
                            destData[dp + 2] = (byte)(data >>> 8);
                            destData[dp + 3] = (byte)(data & 0xFF);
                            break;
                        }
                        case 5: {
                            destData[dp] = (byte)(data & 0xFF);
                            destData[dp + 1] = (byte)(data >>> 8);
                            destData[dp + 2] = (byte)(data >>> 16);
                            destData[dp + 3] = (byte)(data >>> 24);
                        }
                    }
                }
                --dx;
                dp += dprxi;
                sfx = (sfx & 0xFFFF) + sfxi;
            }
            --dy;
            sp = spr += (sfy >>> 16) * srcStride;
            ap = apr += (sfy >>> 16) * alphaStride;
            sfy = (sfy & 0xFFFF) + sfyi;
            dp = dpr += dpryi;
        }
    }

    static int getChannelShift(int mask) {
        if (mask == 0) {
            return 0;
        }
        int i = 0;
        while ((mask & 1) == 0 && i < 32) {
            mask >>>= 1;
            ++i;
        }
        return i;
    }

    static int getChannelWidth(int mask, int shift) {
        if (mask == 0) {
            return 0;
        }
        mask >>>= shift;
        int i = shift;
        while ((mask & 1) != 0 && i < 32) {
            mask >>>= 1;
            ++i;
        }
        return i - shift;
    }
}

