package ui;

import java.util.Random;
import javax.vecmath.Tuple3f;
import org.eclipse.swt.opengl.GL;

// Referenced classes of package ui:
//            TriNode

public class AnimObject
{

    public AnimObject(int level, float scale, float _rotScale, int _startFrom)
    {
        mRoot = new TriNode();
        startFrom = 0;
        maxFrame = 500;
        showFrom = 0;
        breakFrom = 45;
        explodeFrom = 50;
        scaleStep = 0;
        rotScale = 0.0F;
        tframe = 0;
        movScale = 1.0F;
        rnd = new Random(System.currentTimeMillis());
        tcnt = 0;
        rotScale = _rotScale;
        mRoot.initTetrahedron(level, scale);
        genVectorsRecursive(mRoot);
        startFrom = _startFrom;
    }

    public static void main(String args1[])
    {
    }

    public void render(int _frame)
    {
        if(_frame < startFrom)
            return;
        _frame -= startFrom;
        if(_frame == startFrom)
            movScale = 1.0F + (float)Math.abs(rnd.nextInt() % 20) / 15F;
        frame = _frame % maxFrame;
        scaleStep = 0;
        if(frame < showFrom)
            return;
        if(frame < explodeFrom)
        {
            scaleStep = frame - showFrom;
            tframe = frame - breakFrom;
            frame = 0;
        } else
        {
            scaleStep = explodeFrom - showFrom;
            tframe = frame - 2 - breakFrom;
            frame -= explodeFrom;
        }
        addTriRecursive(mRoot, 0, 0);
    }

    public void genVectorsRecursive(TriNode node)
    {
        if(node.isLeaf())
        {
            node.r = (float)Math.abs(rnd.nextInt() % 10) / 10F;
            node.g = (float)Math.abs(rnd.nextInt() % 10) / 10F;
            node.b = (float)Math.abs(rnd.nextInt() % 10) / 10F;
            float as = 10F;
            node.rX = (as * (float)Math.abs(rnd.nextInt() % 100)) / 100F;
            node.rY = (as * (float)Math.abs(rnd.nextInt() % 100)) / 100F;
            node.rZ = (as * (float)Math.abs(rnd.nextInt() % 100)) / 100F;
            node.mov = 0.01F + (float)Math.abs(rnd.nextInt() % 100) / 1000F;
            node.rX *= rotScale;
            node.rY *= rotScale;
            node.rZ *= rotScale;
        }
        if(!node.isLeaf())
        {
            for(int i = 0; i != node.clst.length; i++)
                genVectorsRecursive(node.clst[i]);

        }
    }

    private void addTriRecursive(TriNode node, int level, int ofs)
    {
        javax.vecmath.Point3f p[] = node.spts;
        if(node.isLeaf())
        {
            float step = 15F;
            float trasnScale = 1.0F + (float)tframe * node.mov * movScale;
            float scale = 0.2F + (float)scaleStep / 50F;
            GL.glPushMatrix();
            GL.glScalef(scale, scale, scale);
            GL.glPushMatrix();
            GL.glTranslatef(((Tuple3f) (node.vec)).x * trasnScale, ((Tuple3f) (node.vec)).y * trasnScale, ((Tuple3f) (node.vec)).z * trasnScale);
            GL.glPushMatrix();
            if (true)
            {
            GL.glRotatef(node.rX * (float)frame, 1.0F, 0.0F, 0.0F);
            GL.glRotatef(node.rY * (float)frame, 0.0F, 1.0F, 0.0F);
            GL.glRotatef(node.rZ * (float)frame, 0.0F, 0.0F, 1.0F);
            }
            GL.glPushMatrix();
            GL.glTranslatef(-((Tuple3f) (node.vec)).x, -((Tuple3f) (node.vec)).y, -((Tuple3f) (node.vec)).z);
            tcnt++;
            GL.glColor3f(node.r, node.g, node.b);
            GL.glBegin(4);
            javax.vecmath.Point3f mid = node.mid;
            GL.glNormal3f(((Tuple3f) (node.normal)).x, ((Tuple3f) (node.normal)).y, ((Tuple3f) (node.normal)).z);
            GL.glVertex3f(((Tuple3f) (p[0])).x, ((Tuple3f) (p[0])).y, ((Tuple3f) (p[0])).z);
            GL.glVertex3f(((Tuple3f) (p[1])).x, ((Tuple3f) (p[1])).y, ((Tuple3f) (p[1])).z);
            GL.glVertex3f(((Tuple3f) (p[2])).x, ((Tuple3f) (p[2])).y, ((Tuple3f) (p[2])).z);
            GL.glEnd();
            GL.glPopMatrix();
            GL.glPopMatrix();
            GL.glPopMatrix();
            GL.glPopMatrix();
        }
        if(!node.isLeaf())
        {
            for(int i = 0; i != node.clst.length; i++)
                addTriRecursive(node.clst[i], level + 1, i);

        }
    }

    public TriNode mRoot;
    public int frame;
    public int startFrom;
    public int maxFrame;
    public int showFrom;
    public int breakFrom;
    public int explodeFrom;
    public int scaleStep;
    public float rotScale;
    public int tframe;
    public float movScale;
    Random rnd;
    int tcnt;
}
