// Decompiled by Jad v1.5.8g. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.kpdus.com/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   ColorSelectionGroup.java

package ui;

import java.util.Vector;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.opengl.GL;
import org.eclipse.swt.widgets.*;

// Referenced classes of package ui:
//            IColorSelectionListener

class ColorSelectionGroup
    implements Listener
{

    ColorSelectionGroup(Composite parent, int style)
    {
        listeners = new Vector();
        initColor(parent.getDisplay());
        Composite colorGroup = new Composite(parent, style);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        colorGroup.setLayout(layout);
        button = new Button(colorGroup, 0);
        button.setLayoutData(new GridData(128));
        image = new Image(button.getDisplay(), 12, 12);
        drawButtonImage();
        button.setImage(image);
        button.addListener(13, this);
        button.addDisposeListener(new DisposeListener() {

            public void widgetDisposed(DisposeEvent event)
            {
                if(image != null)
                    image.dispose();
                if(color != null)
                    color.dispose();
            }

        }
);
        label = new Label(colorGroup, 0);
        label.setText("Color");
    }

    void addColorSelectionListener(IColorSelectionListener listener)
    {
        listeners.addElement(listener);
    }

    void drawButtonImage()
    {
        GC gc = new GC(image);
        gc.setBackground(color);
        Rectangle bounds = image.getBounds();
        gc.fillRectangle(0, 0, bounds.width, bounds.height);
        gc.drawRectangle(0, 0, bounds.width - 1, bounds.height - 1);
        gc.dispose();
    }

    public void handleEvent(Event e)
    {
        org.eclipse.swt.widgets.Shell shell = button.getShell();
        ColorDialog colorDialog = new ColorDialog(shell);
        colorDialog.setRGB(new RGB(color.getRed(), color.getGreen(), color.getBlue()));
        RGB rgb = colorDialog.open();
        if(rgb == null)
        {
            return;
        } else
        {
            setRGB(rgb);
            notifyListeners(rgb);
            return;
        }
    }

    void initColor(Display display)
    {
        double currentColor[] = new double[4];
        GL.glGetDoublev(2816, currentColor);
        RGB rgb = new RGB((int)currentColor[0] * 255, (int)currentColor[1] * 255, (int)currentColor[2] * 255);
        color = new Color(display, rgb);
    }

    void notifyListeners(RGB rgb)
    {
        IColorSelectionListener listenersArr[] = new IColorSelectionListener[listeners.size()];
        listeners.copyInto(listenersArr);
        for(int i = 0; i < listenersArr.length; i++)
            listenersArr[i].handleColorSelection(rgb);

    }

    void removeColorSelectionListener(IColorSelectionListener listener)
    {
        listeners.removeElement(listener);
    }

    void setText(String text)
    {
        label.setText(text);
    }

    void setRGB(RGB rgb)
    {
        Color oldColor = color;
        color = new Color(button.getDisplay(), rgb);
        drawButtonImage();
        button.setImage(image);
        if(oldColor != null)
            oldColor.dispose();
    }

    private Color color;
    private Label label;
    private Image image;
    private Button button;
    private Vector listeners;


}
