package ui;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;

import util.log;

public class DizzyNoid
{
	public static void main(String[] args)
	{
		log.d("viens du trys...");
		Display display = new Display();
		Shell shell = new Shell(display, SWT.BORDER | SWT.TITLE | SWT.MIN | SWT.MAX|SWT.RESIZE);
		shell.setText("dizzzzzzzzyNoid! :)     [neramybe@gmail.com]");
		shell.setLayout(new FillLayout(256));
		final MultiCanvasAnimator anim = new MultiCanvasAnimator(display, 10);

		GridLayout gl = new GridLayout(4, false);
		shell.setLayout(gl);

		GridData gd1 = new GridData();
		gd1.grabExcessHorizontalSpace = true;
		gd1.grabExcessVerticalSpace = false;
		gd1.verticalAlignment = GridData.FILL;
		gd1.horizontalAlignment = GridData.FILL;
		gd1.horizontalSpan=4;
		Label lbl = new Label(shell, SWT.BORDER);
		lbl
				.setText("Controls: <space> - launch the ball ('yourself')! <enter> - toggle view between First-person and Thrid-person\n"
						+ "                <left> - move platform left, <right> - move platform right\n\n"
						+ " Objective: control the ball with the platform just like in classical BreakOut game,\n"
						+ "                  except that you're watching the whole scene from ball's point of view");
		lbl.setLayoutData(gd1);

		
		GridData gd2 = new GridData();
		gd2.grabExcessHorizontalSpace = false;
		gd2.grabExcessVerticalSpace = false;
		gd2.verticalAlignment = GridData.CENTER;
		gd2.horizontalAlignment = GridData.CENTER;
		Label l2 = new Label(shell, SWT.NONE);
		l2.setText("Game speed:");
		l2.setLayoutData(gd2);
		
		GridData gd3 = new GridData();
		gd3.grabExcessHorizontalSpace = true;
		gd3.grabExcessVerticalSpace = false;
		gd3.verticalAlignment = GridData.FILL;
		gd3.horizontalAlignment = GridData.FILL;

		final Slider slider = new Slider(shell, SWT.HORIZONTAL);
		
		final int delay = 18;
		final int max = 100;
		final int thumb = 5;
		anim.setDelay(delay);
		
		slider.setMaximum(max);
		slider.setThumb(thumb);
		slider.setMinimum(0);
		slider.setSelection(max-delay);
		slider.setLayoutData(gd3);
		slider.addSelectionListener(new SelectionAdapter() {
			
			

			/* (non-Javadoc)
			 * @see org.eclipse.swt.events.SelectionAdapter#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
			 */
			@Override
			public void widgetDefaultSelected(SelectionEvent e)
			{
				// TODO Auto-generated method stub
				super.widgetDefaultSelected(e);
			}

			/* (non-Javadoc)
			 * @see org.eclipse.swt.events.SelectionAdapter#widgetSelected(org.eclipse.swt.events.SelectionEvent)
			 */
			@Override
			public void widgetSelected(SelectionEvent e)
			{
				dbg("slider " + slider.getSelection());
				anim.setDelay((max - slider.getSelection())+thumb);
			}});
		
		
		Label l3 = new Label(shell, SWT.NONE);
		l3.setText("Platfrom position:");
		GridData gd22 = new GridData();
		gd22.grabExcessHorizontalSpace = false;
		gd22.grabExcessVerticalSpace = false;
		gd22.verticalAlignment = GridData.CENTER;
		gd22.horizontalAlignment = GridData.CENTER;
		l3.setLayoutData(gd22);
		
		Game game = new Game();
		HintCanvas hint = new HintCanvas(shell, SWT.BORDER, game);
		hint.setSize(10,10);
		GridData gd11 = new GridData();
		gd11.grabExcessHorizontalSpace = true;
		gd11.grabExcessVerticalSpace = false;
		gd11.verticalAlignment = GridData.FILL;
		gd11.horizontalAlignment = GridData.FILL;
		gd11.heightHint = 20;
		hint.setLayoutData(gd11);
		
		NoidCanvas cvs = null;
		if (true)
		{
			cvs = new NoidCanvas(shell, SWT.BORDER, hint, game);
			cvs.initGL();
			GridData gd4 = new GridData();
			gd4.grabExcessHorizontalSpace = true;
			gd4.grabExcessVerticalSpace = true;
			gd4.verticalAlignment = GridData.FILL;
			gd4.horizontalAlignment = GridData.FILL;
			gd4.horizontalSpan = 4;
			cvs.setLayoutData(gd4);
			anim.addCanvas(cvs);
			anim.run();
		}
		
		//System.exit(0);

		shell.setSize(1000, 800);
		shell.setLocation(30, 0);
		shell.open();
		log.d("ajna!!" + "");
		
		cvs.setFocus();

		while (!shell.isDisposed())
			if (!display.readAndDispatch())
				display.sleep();
		display.dispose();
	}
	public static void dbg(String msg)
	{
		System.out.println("DBG:: " + msg);
	}

}
