package ui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Random;

import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.MessageBox;

public class Game
{
	public static final int COLS = 25;

	public static final int ROWS = COLS;

	public static final float WIDTH = 1f;

	public static final float HEIGHT = 1f;
	
	public static final float MAX_ELEVATION = HEIGHT;

	public static final float PLAT_WIDTH = WIDTH * 4f;

	public static final float PLAT_HEIGHT = HEIGHT;

	public static final float MARGIN = 0.8f;

	public static final float FLD_WIDTH = COLS * WIDTH;

	public static final float FLD_HEIGHT = ROWS * HEIGHT;

	public static final float BRICK_HEIGHT = 0.5f;

	public Box[][] field;

	public static final float BALL_STEED = HEIGHT / 4f;

	public static final float RADIUS = HEIGHT / 4;

	public static final float PLATF_STEP = WIDTH * 0.5f;

	public NoidCanvas canvas;

	public Rect platfRect = new Rect();

	public Point3f ballPos = new Point3f();

	public Point3f prevBallPos = new Point3f();

	public Vector3f ballDirVec = new Vector3f();

	public Point3f sourcePos = new Point3f();

	public Point3f targetPos = new Point3f();

	public int iteration = 0;

	public float pathLen;

	public boolean ballStopped = true;

	public Rect hitRect;

	public Box hitBox;

	public boolean hitVerticalSide = false;
	
	public float eyeElev = 0f;
	
	public Random rnd = new Random(System.currentTimeMillis());

	public Point3f[] COLORS =
	{
			new Point3f(1f, 1f, 0f), new Point3f(1f, 0f, 1f), new Point3f(0f, 1f, 1f),
			new Point3f(0f, 1f, 0f),
	};
	
	public void loadLevel(int no)
	{
		try
		{
			File fl = new File("level_" + no + ".txt");
			FileReader fr = new FileReader(fl);
			BufferedReader br = new BufferedReader(fr);
			String line = null;
			int r = ROWS - 1;
			while ((line = br.readLine()) != null)
			{
				for (int c = 0; c != COLS; ++c)
				{
					char ch = line.charAt((COLS-c)-1);
					if (ch >= 'a' && ch <= 'z')
					{
						int idx = ch - 'a';
						dbg("adding at " + c + " - " + r);
						addBoxAt(c, r, Box.BRICK, COLORS[idx]);
					}
				}

				--r;
			}

			br.close();
			fr.close();
		}
		catch (Throwable e)
		{
			e.printStackTrace();
			dbg("got ex " + e);
		}
	}

	public void init(NoidCanvas canvas)
	{
		this.canvas = canvas;

		field = new Box[ROWS][COLS];

		int midX = COLS / 2;
		int midY = ROWS / 2;
		int step = 1;

		if (!true)
		{
			int x = COLS / 4;
			int y = ROWS / 4;
			int n = 6;
			for (int r = y; r < y + n; r += step)
				for (int c = x; c < x + n; c += step)
				{
					addBoxAt(c, r, Box.BRICK, COLORS[c % 2]);
				}
		}
		else
			loadLevel(1);

		// add border rows

		// left-vertical
		if (!false)
			for (int r = 0; r != ROWS; ++r)
				addBoxAt(0, r, Box.WALL, null);

		// right-vertical
		if (!false)
			for (int r = 0; r != ROWS; ++r)
				addBoxAt(COLS - 1, r, Box.WALL, null);

		// top
		if (!false)
			for (int c = 0; c != COLS; ++c)
				addBoxAt(c, ROWS - 1, Box.WALL, null);

		// if (!false)
		// for (int c = 0; c != COLS; ++c)
		// addBoxAt(c, ROWS - 1, Box.LAVA);

		centerPlatform();

		// signalReleaseBall();
	}

	private void centerPlatform()
	{
		platfRect.x = ((FLD_WIDTH / 2f) - PLAT_WIDTH / 2f) - PLAT_WIDTH;
		platfRect.z = 0f;
		platfRect.width = PLAT_WIDTH;
		platfRect.height = PLAT_HEIGHT;

		centerBall();
	}

	private void centerBall()
	{
		sourcePos.x = platfRect.x + platfRect.width / 2f;
		sourcePos.z = platfRect.z + platfRect.height + RADIUS;

		ballDirVec = new Vector3f(1f, 0f, 1f);
		ballDirVec.normalize();

		ballStopped = true;

		ballPos.x = sourcePos.x;
		ballPos.z = sourcePos.z;
		
		wiggleBallDir();
	}

	private void traceNextTarget()
	{
		for (int i = 1;; ++i)
		{
			float x = sourcePos.x + ballDirVec.x * (BALL_STEED * (float) i);
			float z = sourcePos.z + ballDirVec.z * (BALL_STEED * (float) i);

			// dbg(" x " + x + " z " + z);

			if (hitTest(x, z) || hitsLava(x, z))
			{
				float dx = x - ballPos.x;
				float dz = z - ballPos.z;

				pathLen = (float) Math.sqrt(dx * dx + dz * dz);
				break;
			}
		}
	}

	public boolean hitsLava(float x, float z)
	{
		return z - RADIUS < 0f;
	}

	public boolean hitTestBallAndRect(Rect r, float x, float z)
	{
		// test center-points of all four edges of the ball against the given
		// rect

		if (r.hasPoint(x - RADIUS, z))
		{
			hitVerticalSide = true;
			return true;
		}

		if (r.hasPoint(x + RADIUS, z))
		{
			hitVerticalSide = true;
			return true;
		}

		if (r.hasPoint(x, z - RADIUS))
		{
			hitVerticalSide = false;
			return true;
		}

		if (r.hasPoint(x, z + RADIUS))
		{
			hitVerticalSide = false;
			return true;
		}

		return false;
	}

	public boolean hitTest(float x, float z)
	{
		if (hitTestBallAndRect(platfRect, x, z))
		{
			hitBox = null;
			hitRect = platfRect;
			return true;
		}

		for (int r = 0; r != ROWS; ++r)
			for (int c = 0; c != COLS; ++c)
				if (field[r][c] != null)
				{
					Box b = field[r][c];
					if (hitTestBallAndRect(b.r, x, z))
					{
						hitBox = b;
						hitRect = b.r;
						return true;
					}
				}

		return false;
	}

	public void signalReleaseBall()
	{
		if (!ballStopped)
		{
			ballStopped = true;
			centerBall();
			return;
		}

		traceNextTarget();

		ballStopped = false;

		iteration = 0;
	}

	public void signalNewFrame()
	{
		if (ballStopped)
			return;

		++iteration;

		prevBallPos.x = ballPos.x;
		prevBallPos.z = ballPos.z;

		float ofsX = ballDirVec.x * (BALL_STEED * (float) iteration);
		float ofsZ = ballDirVec.z * (BALL_STEED * (float) iteration);
		
		float dist = (float)Math.sqrt(ofsX*ofsX + ofsZ*ofsZ);
		float pathRatio = dist/pathLen;
		if (pathRatio > .5)
			pathRatio = 1f - pathRatio;
		

		eyeElev = MAX_ELEVATION*(pathRatio*2f);
		//dbg("ratio " + pathRatio);

		ballPos.x = sourcePos.x + ofsX;
		ballPos.z = sourcePos.z + ofsZ;

		if (hitsLava(ballPos.x, ballPos.z))
		{
			MessageBox box =new MessageBox(canvas.getShell(), SWT.ICON_WARNING);
			box.setText("Oops!");
			box.setMessage("You've MISSED the (blue) platform and dissolved into the red fires of hEll ! >:-( "
					+ "\n\n(use <right> <left> arrow keys to try and control that blue platform when you see it, but also when you DON'T! :)");
			box.open();
			
			ballStopped = true;
			centerPlatform();
			return;
		}

		if (hitTest(ballPos.x, ballPos.z))
		{
			sourcePos.x = prevBallPos.x;
			sourcePos.z = prevBallPos.z;

			if (hitVerticalSide)
				ballDirVec.x = -ballDirVec.x;
			else
				ballDirVec.z = -ballDirVec.z;
			
			if (hitRect == platfRect)
			{
				// TODO do proper bounce-angle matching, not this quick-n-dirty randomizing

				wiggleBallDir();
			}

			iteration = 0;

			if (hitBox != null && hitBox.type == Box.BRICK)
			{
				field[hitBox.row][hitBox.col] = null;
				canvas.removeGlyph(hitBox.glyph);
			}

			traceNextTarget();
		}
	}

	private void wiggleBallDir()
	{
		int ampl = 50;
		float dx = (float)(rnd.nextInt() % ampl);
		float dz = (float)(rnd.nextInt() % ampl);
		dx = (dx/100f)*WIDTH;
		dz = (dz/100f)*HEIGHT;
		dbg("dx " + dx+ " dz " + dz);
		ballDirVec.x += dx;
		ballDirVec.z += dz;
		ballDirVec.normalize();
	}

	public void singalPlatformControl(boolean left)
	{
		platfRect.x += PLATF_STEP * (left ? -1f : 1f);

		// bounds-check
		if (platfRect.x <= WIDTH)
			platfRect.x = WIDTH;

		if (platfRect.x + platfRect.width >= FLD_WIDTH - WIDTH)
			platfRect.x = (FLD_WIDTH - WIDTH) - platfRect.width;

		if (ballStopped)
			centerBall();
	}

	public void addBoxAt(int col, int row, int type, Point3f color)
	{
		Box b = new Box();
		b.type = type;
		field[row][col] = b;
		b.col = col;
		b.row = row;

		// calc bounds
		b.r = new Rect();
		b.r.x = col * WIDTH;
		b.r.z = row * HEIGHT;
		b.r.width = WIDTH;
		b.r.height = HEIGHT;
		b.color = color;
	}

	public static void dbg(String msg)
	{
		System.out.println("DBG:: " + msg);
	}
}




















