package ui;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;

public class HintCanvas extends Composite
{
	int margin = 2;
	Color fg = new Color(null,0,0,192);
	Game game;

	public HintCanvas(Composite parent, int style, Game game)
	{
		super(parent, style);
		this.game = game;
		setBackground(new Color(null, 0,0,0));
		
		addPaintListener(new PaintListener() {

			public void paintControl(PaintEvent arg0)
			{
				doPaint(arg0.gc);
			}});
	}
	
	public void doPaint(GC g)
	{
		int w = getClientArea().width;
		int h = getClientArea().height;

		float gFrom = game.platfRect.x;
		float gTo = game.platfRect.x + game.platfRect.width;

		int from = toX(gFrom);
		int to = toX(gTo);
		float gCenter = game.platfRect.x + game.platfRect.width / 2f;

		dbg("gFrom " + gFrom + " gTo " + gTo + " from " + from + " to " + to + " WIDTH "
				+ Game.FLD_WIDTH + " w " + w);

		g.setBackground(fg);
		int c = toX(gCenter);
		int rw = 10;
		g.fillRectangle(from, margin, to-from, h - margin * 2);
		//g.fillRectangle(c-rw, margin, c+rw, h - margin * 2);
	}
	
	public int toX(float gameX)
	{
		float w = getClientArea().width;
		float ratio = gameX /Game.FLD_WIDTH;
		
		return (int)(w * ratio);
	}

	public static void dbg(String msg)
	{
		System.out.println("DBG:: " + msg);
	}
}
