package ui;

import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.opengl.GL;
import org.eclipse.swt.widgets.Composite;

import util.log;

public class KolorCanvas extends MyCanvas
{
	public KolorCanvas(Composite parent, int style)
	{
		super(parent, style);
	}

	public void renderScene()
	{
		super.renderScene();

		if (useLights)
		{
			float k = 5000F;
			float position[] =
			{
					-k, -k, -k, 0.0F
			};
			GL.glLightfv(16384, 4611, position);
			float lint = 1.0F;
			float diffuse[] =
			{
					lint, lint, lint, 0.0F
			};
			GL.glLightfv(16384, 4609, diffuse);
			float aint = 0.5F;
			float ambient[] =
			{
					aint, aint, aint
			};
			GL.glLightfv(16384, 4608, ambient);
			GL.glLightfv(GL.GL_LIGHT0, GL.GL_AMBIENT, ambient);
			GL.glEnable(GL.GL_LIGHTING);
			GL.glEnable(GL.GL_LIGHT0);
		}
		
		GL.glLoadIdentity();
		GL.glTranslatef(0.0F, 0.0F, -15F);
		GL.glRotatef(xRot, 1.0F, 0.0F, 0.0F);
		GL.glRotatef(xRot, 0.0F, 0.0F, 1.0F);
		if (fill)
			GL.glPolygonMode(GL.GL_FRONT_AND_BACK, GL.GL_FILL);
		// GL.glPolygonMode(GL.GL_FRONT_AND_BACK, GL.GL_LINE);
		else
			// GL.glPolygonMode(1032, 6913);
			GL.glPolygonMode(GL.GL_FRONT_AND_BACK, GL.GL_LINE);
		for (int i = 0; i < mShapes.size(); i++)
		{
			Shape e = (Shape) mShapes.elementAt(i);
			//GL.glCallList(e.mIdx);
		}

		if (useLights)
		{
			if (rx == -100F)
			{
				rx = (float) (rnd.nextInt() % 50) / 100F;
				ry = (float) (rnd.nextInt() % 50) / 100F;
				rz = (float) (rnd.nextInt() % 50) / 100F;
			}
			int k = 175;
			float j = 120F;
			float f1 = mF1 / j;
			float f2 = mF2 / j;
			float f3 = mF3 / j;
			float r = Math.abs((float) Math.cos(f1 * rx));
			float g = Math.abs((float) Math.sin(f2 * ry));
			float b = Math.abs((float) Math.cos(f3 * rz));
			float material1[] =
			{
					r, g, b, 1.0F
			};
			float mat_specular[] =
			{
					0.0F, 0.0F, 1.0F, 1.0F
			};
			float mat_shininess[] =
			{
				1.0F
			};
			GL.glMaterialfv(1032, 5634, material1);
			GL.glMaterialfv(1032, 5633, mat_shininess);
		}

		//drawCube(2f, 2f, 2f);
		//drawSquare(2,7);

			for (int i = 0; i != mAnims.size(); i++)
			{
				AnimObject obj = (AnimObject) mAnims.elementAt(i);
				obj.render((int) ((float) mFrame * mMultFrame));
			}

		yRot += 1.5D;
		xRot += 1.5D;
		mFrame++;
		float lim = 1500F;
		if (Math.abs(mF1) >= lim)
		{
			log.d("flip 1");
			rx = -rx;
		}
		if (Math.abs(mF2) >= lim)
		{
			log.d("flip 2");
			ry = -ry;
		}
		if (Math.abs(mF3) >= lim)
		{
			log.d("flip 3");
			rz = -rz;
		}
		mF1 += rx;
		mF2 += ry;
		mF3 += rz;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see ui.MyCanvas#keyPressed(org.eclipse.swt.events.KeyEvent)
	 */
	@Override
	public void keyPressed(KeyEvent e)
	{
		super.keyPressed(e);
		
		float inc = 0.1F;
		if (e.character == 'a')
			mMultFrame -= inc;
		else if (e.character == 'q')
			mMultFrame += inc;
		else if (e.character == 'n')
			mMultFrame = 1.0F;
		float m = 1.5F;
		if (e.character == 'w')
		{
			rx *= m;
			ry *= m;
			rz *= m;
		}
		else if (e.character == 's')
		{
			rx /= m;
			ry /= m;
			rz /= m;
		}
	}
	
	
}
