package ui;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.*;
import util.log;

// Referenced classes of package ui:
//            MultiCanvasAnimator, MyCanvas, AnimObject

public class KolorMain
{

    public KolorMain()
    {
    }

    public static void main(String args[])
    {
        log.d("viens du trys...");
        Display display = new Display();
        Shell shell = new Shell(display, 0x404f0);
        shell.setText("Koloringumas-3d (vartojimo budas: vakare su muzika), 2005 (c) neramybe@gmail.com");
        shell.setLayout(new FillLayout(256));
        MultiCanvasAnimator anim = new MultiCanvasAnimator(display, 20);

        KolorCanvas cvs = new KolorCanvas(shell, 2048);
        cvs.initGL();
        
        for(int i = 0; i != 4; i++)
        {
            float rotScale = 0.6F + (float)(i % 4) * 0.5F;
            AnimObject a = new AnimObject(1 + i % 4, 10F, rotScale, i * 80);
            cvs.addAnimObject(a);
        }


        anim.addCanvas(cvs);
        anim.run();
        shell.setSize(1600, 1000);
        shell.setLocation(30, 0);
        shell.open();
        log.d("ajna!");
        while(!shell.isDisposed()) 
            if(!display.readAndDispatch())
                display.sleep();
        display.dispose();
    }
}
