// Decompiled by Jad v1.5.8g. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.kpdus.com/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   MyCanvas.java

package ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Vector;

import javax.vecmath.Tuple3f;

import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.opengl.GL;
import org.eclipse.swt.opengl.GLContext;
import org.eclipse.swt.opengl.GLU;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

// Referenced classes of package ui:
//            Shape3D, AnimObject, TriNode

public class MyCanvas extends Canvas implements PaintListener, ControlListener,
		KeyListener
{
	public static final float PI = (float)Math.PI;
	public static final float PI_2 = (float)Math.PI/2f;
	
	public static final int IDX_GROUND_TEXTURE = 1;

	public static final int IDX_SKY_TEXTURE = 2;

	GLContext mContext;

	static final float DIST = -15F;

	protected static int mCnt = 1;

	protected int mNum;

	protected static float XROT = 0.0F;

	protected static float YROT = 180f;

	protected float xRot;

	protected float yRot;

	protected boolean fill;

	protected int quadratic;

	protected static final int SLEEP_LENGTH = 50;

	protected static int mShapeIdx = -1;

	protected int mCurIdx;

	protected Vector mShapes;

	protected Vector mAnims;

	protected int mTextures[];

	protected int mCntTextures;

	public int mFrame;

	public float mMultFrame;

	public float rx;

	public float ry;

	public float rz;

	public float mF1;

	public float mF2;

	public float mF3;

	public static boolean useTexture = true;

	public static boolean useLights = true;

	public static boolean wireFrame = false;
	
	public static boolean rotate = false;

	public Random rnd;

	public int tcnt;

	public Shape sampleShape;

	public List<Glyph> glyphs = new ArrayList<Glyph>();

	static Class class$0; /* synthetic field */

	public class AnimTimer implements Runnable
	{

		public void run()
		{
			if (isDisposed())
			{
				return;
			}
			else
			{
				renderScene();
				swap();
				mDisplay.timerExec(mDelay, this);
				return;
			}
		}

		Display mDisplay;

		int mDelay;

		public AnimTimer(Display display, int delay)
		{
			mDisplay = display;
			mDelay = delay;
		}
	}

	public void keyPressed(KeyEvent e)
	{
		if (e.character == 'l')
			System.exit(0);
	}

	public void keyReleased(KeyEvent keyevent)
	{
	}

	public void endDisplayList()
	{
		GL.glEndList();
	}

	public void controlMoved(ControlEvent arg0)
	{
		setupViewingArea();
	}

	public void controlResized(ControlEvent arg0)
	{
		Rectangle rect = getClientArea();
		mContext.resize(0, 0, rect.width, rect.height);
		setupViewingArea();
	}

	public void paintControl(PaintEvent arg0)
	{
		renderScene();
		swap();
	}

	public void startAnimating(Display display, int delay)
	{
		Display d = null;
		Runnable timer = new AnimTimer(display, delay);
		timer.run();
	}

	public float rotateCol(float c)
	{
		if (c > 1.0F)
		{
			int n = (int) Math.floor(c);
			if (n % 2 == 1)
			{
				c -= n;
				c = 1.0F - c;
			}
			else
			{
				c -= n;
			}
		}
		c = (float) ((double) c - 0.20000000000000001D);
		return c;
	}

	public void renderScene()
	{
		setCurrent();
		if (isDisposed())
			return;
		setupViewingArea();
		// GL.glClear(16640);
		GL.glClear(GL.GL_COLOR_BUFFER_BIT | GL.GL_DEPTH_BUFFER_BIT);
	}

	public void addAnimObject(AnimObject obj)
	{
		mAnims.add(obj);
	}

	public void swap()
	{
		if (isDisposed())
		{
			return;
		}
		else
		{
			setCurrent();
			mContext.swapBuffers();
			return;
		}
	}

	public void setCurrent()
	{
		if (isDisposed())
		{
			return;
		}
		else
		{
			mContext.setCurrent();
			return;
		}
	}

	public MyCanvas(Composite parent, int style)
	{
		super(parent, style);
		fill = true;
		mCurIdx = 1;
		mShapes = new Vector();
		mAnims = new Vector();
		mTextures = new int[10];
		mCntTextures = 0;
		mFrame = 0;
		mMultFrame = 1.0F;
		rx = -100F;
		rnd = new Random();
		tcnt = 0;
		mContext = new GLContext(this);
		mContext.setCurrent();
		mNum = mCnt;
		mCnt++;
		xRot = XROT;
		yRot = YROT;
		XROT += 45F;
		YROT += 45F;
		addPaintListener(this);
		addControlListener(this);
		addKeyListener(this);
	}

	protected void initGL()
	{
		GL.glHint(GL.GL_PERSPECTIVE_CORRECTION_HINT, GL.GL_NICEST);
		GL.glClearColor(0.0F, 0.0F, 0.0F, 0.0F);
		GL.glClearDepth(1.0D);
		GL.glEnable(GL.GL_TEXTURE_2D);
		GL.glEnable(GL.GL_LIST_MODE);
		GL.glEnable(GL.GL_DEPTH_TEST);
		GL.glDepthFunc(GL.GL_LEQUAL);
		//GL.glShadeModel(GL.GL_PHONG_WIN);
		//GL.glShadeModel(GL.GL_SMOOTH);
		quadratic = GLU.gluNewQuadric();
		// GLU.gluQuadricNormals(quadratic, 0x186a0);
		GL.glLineWidth(2.0F);

		GL.glEnable(GL.GL_LIGHTING);

		if (useTexture)
		{
			GL.glTexEnvf(GL.GL_TEXTURE_ENV, GL.GL_TEXTURE_ENV_MODE, 8448F);
			GL.glGenTextures(mTextures.length, mTextures);
			doLoadTextures();
		}
		GL.glEnable(GL.GL_DEPTH_TEST);

		doLoadShapes();
		doInitSceneGraph();
		
		mF1 = Math.abs(rnd.nextInt() % 500);
		mF2 = Math.abs(rnd.nextInt() % 500);
		mF3 = Math.abs(rnd.nextInt() % 500);
	}

	protected void doLoadTextures()
	{
		// specific implementation defined in the derived classes
	}
	
	protected void doLoadShapes()
	{
		// specific implementation defined in the derived classes
	}
	
	protected void doInitSceneGraph()
	{
		// specific implementation defined in the derived classes
	}

	protected void setupViewingArea()
	{
		setCurrent();
		Rectangle rect = getClientArea();
		int width = rect.width;
		int height = rect.height;
		height = Math.max(height, 1);
		int ofs = 0;
		
		GL.glViewport(ofs, ofs, width - ofs, height - ofs);
		GL.glMatrixMode(GL.GL_PROJECTION);
		GL.glLoadIdentity();
		
		float fAspect = (float) width / (float) height;
		
		GLU.gluPerspective(70D, fAspect, 0.5D, 1000D);
		
		GL.glMatrixMode(GL.GL_MODELVIEW);
		GL.glLoadIdentity();
	}

	public void loadTeexture(String fileName, int idx)
	{
		GL.glBindTexture(GL.GL_TEXTURE_2D, mTextures[idx]);
		/*
		 * JVM INSTR new #464 <Class ImageData>; JVM INSTR dup ; class$0;
		 * if(class$0 != null) goto _L2; else goto _L1 _L1: JVM INSTR pop ;
		 * class$0 = Class.forName("[Lui.MyCanvas;").getComponentType(); goto
		 * _L2 JVM INSTR new #480 <Class NoClassDefFoundError>; JVM INSTR dup_x1
		 * ; JVM INSTR swap ; getMessage(); NoClassDefFoundError(); throw ; _L2:
		 * fileName; getResourceAsStream(); ImageData(); ImageData source;
		 * source;
		 */

		int stdWidth = 1024;
		int stdHeight = 1025;
		Image timg = new Image(null, fileName);

		ImageData source = mContext.convertImageData(timg.getImageData());

		GL.glTexImage2D(GL.GL_TEXTURE_2D, 0, 3, source.width, source.height, 0,
				GL.GL_RGB, GL.GL_UNSIGNED_BYTE, source.data);
		
		GLU.gluBuild2DMipmaps(GL.GL_TEXTURE_2D, 3, source.width, source.height, 
				GL.GL_RGB, GL.GL_UNSIGNED_BYTE, source.data);

		GL.glTexParameteri(GL.GL_TEXTURE_2D, GL.GL_TEXTURE_MIN_FILTER, GL.GL_LINEAR_MIPMAP_LINEAR);
		GL.glTexParameteri(GL.GL_TEXTURE_2D, GL.GL_TEXTURE_MAG_FILTER, GL.GL_LINEAR);

		timg.dispose();
	}

	void drawSquare(float width, float height)
	{
		GL.glBegin(GL.GL_QUADS);
		GL.glVertex3f(-width, -height, 0.0F);
		GL.glVertex3f(width, -height, 0.0F);
		GL.glVertex3f(width, height, 0.0F);
		GL.glVertex3f(-width, height, 0.0F);
		GL.glEnd();
	}

	public Shape addShape(String fname)
	{
		
		OBJReader reader = new OBJReader();
		reader.readFile(fname);

		Shape s = new Shape(reader.polys);
		
		
		
		s.dispListIndex = mCurIdx;
		GL.glNewList(mCurIdx, GL.GL_COMPILE);
		s.render();
		GL.glEndList();
		mShapes.add(s);
		mCurIdx++;

		return s;
	}
	
	public Glyph addGlyph(String shapeFileName)
	{
		Shape s = addShape(shapeFileName);
		return addGlyph(new Glyph(s));
	}
	
	public void removeGlyph(Glyph glyph)
	{
		glyphs.remove(glyph);
	}
	
	public Glyph addGlyph(Glyph glyph)
	{
		this.glyphs.add(glyph);
		return glyph;
	}

	public void drawGlyph(Glyph g)
	{
		// TODO transform
		GL.glPushMatrix();
		GL.glTranslatef(g.pos.x, g.pos.y, g.pos.z);
		GL.glScalef(g.scale.x, g.scale.y, g.scale.z);
		setMaterials(g.color.x, g.color.y, g.color.z);
		GL.glCallList(g.shape.dispListIndex);
		GL.glPopMatrix();
	}
	
	public void setMaterials(float r, float g, float b)
	{
		if (useLights)
		{
			float material1[] =
			{
					r, g, b, 1F
			};
			GL.glMaterialfv( 1032, GL.GL_AMBIENT_AND_DIFFUSE, material1);
			//GL.glMaterialfv(1032, GL.GL_SHININESS, new float[] {0f,0f,0f});
			//GL.glMaterialfv(1032, GL.GL_SHININESS, mat_shininess);
			//GL.GL_2_BYTES
		}
	}
	
	public void drawAllGlyphs()
	{
		for(Glyph g : glyphs)
			drawGlyph(g);
	}

	void drawHorizSquare(float width, float height, float y, int textureIdx)
	{
		if (textureIdx == -1 || !useTexture)
		{
			GL.glBegin(GL.GL_QUADS);
			GL.glVertex3f(0, y, 0);
			GL.glVertex3f(width, y, 0);
			GL.glVertex3f(width, y, height);
			GL.glVertex3f(0, y, height);
			GL.glEnd();
		}
		else
		{
			float nx = 0f;
			float ny = 5f;
			float nz = 0f;

			GL.glBindTexture(GL.GL_TEXTURE_2D, mTextures[textureIdx]);
			GL.glBegin(GL.GL_QUADS);

			GL.glNormal3f(nx, ny, nz); // up
			GL.glTexCoord2d(1f, 0f);
			GL.glVertex3f(0, y, 0);

			GL.glNormal3f(nx, ny, nz); // up
			GL.glTexCoord2d(0f, 0f);
			GL.glVertex3f(width, y, 0);

			GL.glNormal3f(nx, ny, nz); // up
			GL.glTexCoord2d(0f, 1f);
			GL.glVertex3f(width, y, height);

			GL.glNormal3f(nx, ny, nz); // up
			GL.glTexCoord2d(1f, 1f);
			GL.glVertex3f(0, y, height);

			GL.glEnd();
			// loadTeexture(mContext, );
		}
	}

	void drawCube(float width, float height, float depth)
	{
		GL.glBegin(GL.GL_QUADS);
		GL.glVertex3f(-width, -height, depth);
		GL.glVertex3f(width, -height, depth);
		GL.glVertex3f(width, height, depth);
		GL.glVertex3f(-width, height, depth);
		GL.glVertex3f(-width, -height, -depth);
		GL.glVertex3f(width, -height, -depth);
		GL.glVertex3f(width, height, -depth);
		GL.glVertex3f(-width, height, -depth);
		GL.glVertex3f(-width, -height, -depth);
		GL.glVertex3f(-width, -height, depth);
		GL.glVertex3f(-width, height, depth);
		GL.glVertex3f(-width, height, -depth);
		GL.glVertex3f(width, -height, depth);
		GL.glVertex3f(width, -height, -depth);
		GL.glVertex3f(width, height, -depth);
		GL.glVertex3f(width, height, depth);
		GL.glVertex3f(width, height, -depth);
		GL.glVertex3f(-width, height, -depth);
		GL.glVertex3f(-width, height, depth);
		GL.glVertex3f(width, height, depth);
		GL.glVertex3f(width, -height, depth);
		GL.glVertex3f(-width, -height, depth);
		GL.glVertex3f(-width, -height, -depth);
		GL.glVertex3f(width, -height, -depth);
		GL.glEnd();
	}

	protected void addTriRecursive(TriNode node, int level, int ofs)
	{
		javax.vecmath.Point3f p[] = node.spts;
		if (node.isLeaf())
		{
			float base = 0.3F;
			float r = (float) Math.abs(rnd.nextInt() % 10) / 10F;
			float g = (float) Math.abs(rnd.nextInt() % 10) / 10F;
			float b = (float) Math.abs(rnd.nextInt() % 10) / 10F;
			float step = 15F;
			GL.glPushMatrix();
			GL.glTranslatef(((Tuple3f) (node.vec)).x, ((Tuple3f) (node.vec)).y,
					((Tuple3f) (node.vec)).z);
			GL.glPushMatrix();
			GL.glRotatef(45F, 1.0F, 0.0F, 0.0F);
			GL.glRotatef(45F, 0.0F, 1.0F, 0.0F);
			GL.glRotatef(45F, 0.0F, 0.0F, 1.0F);
			GL.glPushMatrix();
			GL.glTranslatef(-((Tuple3f) (node.vec)).x, -((Tuple3f) (node.vec)).y,
					-((Tuple3f) (node.vec)).z);
			tcnt++;
			GL.glColor3f(r, g, b);
			GL.glBegin(4);
			GL.glVertex3f(((Tuple3f) (p[0])).x, ((Tuple3f) (p[0])).y,
					((Tuple3f) (p[0])).z);
			GL.glVertex3f(((Tuple3f) (p[1])).x, ((Tuple3f) (p[1])).y,
					((Tuple3f) (p[1])).z);
			GL.glVertex3f(((Tuple3f) (p[2])).x, ((Tuple3f) (p[2])).y,
					((Tuple3f) (p[2])).z);
			GL.glEnd();
			GL.glPopMatrix();
			GL.glPopMatrix();
			GL.glPopMatrix();
		}
		if (!node.isLeaf())
		{
			for (int i = 0; i != node.clst.length; i++)
				addTriRecursive(node.clst[i], level + 1, i);

		}
	}

	public static void dbg(String msg)
	{
		System.out.println("DBG:: " + msg);
	}
}
