package ui;

import javax.vecmath.Point3f;

import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.opengl.GL;
import org.eclipse.swt.widgets.Composite;

import util.Geom;


public class NoidCanvas extends MyCanvas
{
	private static final float NO_ANGLE = -10000;
	
	private static final float EYE_ANGLE_STEP = 10f;
	private Game game;
	
	private Shape brickShape;
	private Shape wallShape;
	private Shape lavaShape;
	private Shape platformShape;
	
	private float camDist = -Game.FLD_HEIGHT*1.0f;
	private float camHeight = -10f;//-Game.FLD_HEIGHT/6;
	private float camX = Game.FLD_WIDTH/2f;
	private float camXAngle = -80f;
	private float rotStep = -2.165f*1;
	private boolean thirdPerson = false;
	private float eyeAngle = NO_ANGLE;
	private HintCanvas hint;
	
	public void setPov()
	{
		GL.glLoadIdentity();

		if (!thirdPerson)
		{
			// GL.glTranslatef(camX, camHeight, camDist);

			if (yRot == -1)
			{
				yRot = 0;
				rotStep = 0;
			}

			float ballAngle = (Geom.get_true_arctan(game.ballDirVec.x, game.ballDirVec.z) / PI) * 180f;
			//ballAngle += 90f;

			if (eyeAngle == NO_ANGLE)
			{
				dbg("initial Anlge " + ballAngle);
				eyeAngle = ballAngle;
			}

			// angle = 0f;
			//dbg("angle " + ballAngle + " eyeAngle " + eyeAngle);

			if (eyeAngle != ballAngle)
			{
				float p = ballAngle;
				float q = eyeAngle;

				p -= ballAngle;
				q -= ballAngle;
				
				if (q < 0)
					q += 360f;

				boolean add = q > 180;
				//dbg(" p " + p + " q " + q + " add: " + add + "    ball: " + ballAngle + " eye: " + eyeAngle);

				if (add)
				{
					if (q + EYE_ANGLE_STEP > 360)
						eyeAngle = ballAngle;
					else
						eyeAngle += EYE_ANGLE_STEP;	
				}
				else
				{
					if (q - EYE_ANGLE_STEP < 0)
						eyeAngle = ballAngle;
					else
						eyeAngle -= EYE_ANGLE_STEP;
				}
				
			}

			// angle -= 180f;

			// GL.glTranslatef(Game.FLD_WIDTH/2f,-1f,0f);
			GL.glRotatef(yRot + eyeAngle + 90f, 0.0F, 1f, 0f);
			GL.glTranslatef(-game.ballPos.x, -game.eyeElev, -game.ballPos.z);

		}
		else
		{
			GL.glTranslatef(camX, camHeight, camDist);

			if (rotate)
			{
				// GL.glRotatef(xRot, 1f, 0f, 0f);
				// dbg("yrot " + yRot);
				GL.glRotatef(yRot, 0.0F, 1f, 0f);
				GL.glRotatef(camXAngle, 1f, 0, 0f);
			}
		}

	}
	
	public NoidCanvas(Composite parent, int style, HintCanvas hint, Game game)
	{
		super(parent, style);

		this.hint = hint;
		this.game = game;
		useTexture = true;
		wireFrame = !true;
		rotate = true;
		
		if (!thirdPerson)
		{
			yRot = -1f;
		}
		else
		{
			rotStep = 0;
		}
	}
	
	public void drawStatics()
	{
		drawHorizSquare(Game.FLD_WIDTH, Game.FLD_HEIGHT, -0.5f, IDX_GROUND_TEXTURE);

		GL.glPushMatrix();
		GL.glTranslatef(Game.FLD_WIDTH/2, 0f,-Game.HEIGHT/2f);
		GL.glScalef(Game.FLD_WIDTH, 1f, 1f);

		setMaterials(1f,0.3f,0.3f);
		
		GL.glCallList(wallShape.dispListIndex);
		
		GL.glPopMatrix();
	}
	
	public void drawPlatform()
	{
		GL.glPushMatrix();
		// GL.glRotatef(-90f, 1f,0f,0f);
		// GL.glTranslatef(Game.FLD_WIDTH/2, 0f,Game.HEIGHT/2f);

		GL.glTranslated(game.platfRect.x + game.platfRect.width / 2f, 0f,
				Game.HEIGHT / 2f);
		
		GL.glScalef(game.platfRect.width, Game.HEIGHT, Game.HEIGHT);

		// GL.glScalef(Game.PLAT_WIDTH, 1f, 1f);

		setMaterials(0f, 0.3f, 1f);
		// GL.glMaterialfv(1032, GL.GL_EMISSION, new float[] {1f,0f,0f});

		GL.glCallList(platformShape.dispListIndex);

		GL.glPopMatrix();
	}
	
	public void drawBall()
	{
		GL.glPushMatrix();

		GL.glTranslated(game.ballPos.x, 0f, game.ballPos.z);
		GL.glScalef(Game.RADIUS*2,Game.RADIUS*2,Game.RADIUS*2);

		// GL.glScalef(Game.PLAT_WIDTH, 1f, 1f);

		setMaterials(1.0f, 1.0f, 0.0f);

		GL.glCallList(wallShape.dispListIndex);

		GL.glPopMatrix();
	}
	
	/* (non-Javadoc)
	 * @see ui.MyCanvas#keyPressed(org.eclipse.swt.events.KeyEvent)
	 */
	@Override
	public void keyPressed(KeyEvent e)
	{
		super.keyPressed(e);
		
		//dbg("key pressed " + e.keyCode + " char "  + e.character);
		if (e.keyCode == 27)
			System.exit(0);
		if (e.keyCode == 13)
		{
			thirdPerson = !thirdPerson;
			
			if (!thirdPerson)
			{
				yRot = -1f;
			}
			else
			{
				yRot = 180;
				rotStep = 0;
			}

		}
		
		hint.redraw();
		
		if (e.character == ' ')
			game.signalReleaseBall();
		else
		if (e.keyCode == 16777219)
			// left
			game.singalPlatformControl(true);
		else
		if (e.keyCode == 16777220)
			// right
			game.singalPlatformControl(false);
	}
	
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see ui.MyCanvas#renderScene()
	 */
	@Override
	public void renderScene()
	{
		// exec. the frame-by-frame game logic here
		game.signalNewFrame();

		super.renderScene();

		setPov();
		setLights();

		if (wireFrame)
			GL.glPolygonMode(GL.GL_FRONT_AND_BACK, GL.GL_LINE);
		else
			GL.glPolygonMode(GL.GL_FRONT_AND_BACK, GL.GL_FILL);

		setMaterials(0.8f, 0.8f, 1f);
		setMaterials(1f, 1f, 1f);

		drawStatics();

		setMaterials(0.8f, 0.8f, 1f);
		drawAllGlyphs();
		drawPlatform();

		if (thirdPerson)
			drawBall();

		yRot += rotStep;
		// xRot += rotStep;

		mFrame++;
		float lim = 1500F;
		if (Math.abs(mF1) >= lim)
		{
			// dbg("flip 1");
			rx = -rx;
		}
		if (Math.abs(mF2) >= lim)
		{
			// dbg("flip 2");
			ry = -ry;
		}
		if (Math.abs(mF3) >= lim)
		{
			// dbg("flip 3");
			rz = -rz;
		}
		mF1 += rx;
		mF2 += ry;
		mF3 += rz;
	}
	
	public void setLights()
	{
		if (useLights)
		{
			float pos[] =
			{
					5f, 5f, Game.FLD_HEIGHT, 1f
			};
			
			//GL.glLightfv(GL.GL_LIGHT0, GL.GL_SPOT_DIRECTION, pos);
			//GL.glLightfv(GL.GL_LIGHT0, GL.GL_SPOT_DIRECTION, pos);
			GL.glEnable(GL.GL_LIGHT0);
			GL.glLightfv(GL.GL_LIGHT0, GL.GL_POSITION, pos);
			GL.glLightfv(GL.GL_LIGHT0, GL.GL_COLOR, new float[] {3f,3f,3f});
			float a = 0.5f;
			GL.glLightModelfv(GL.GL_LIGHT_MODEL_AMBIENT, new float[] {a,a,a, 0f});
			//GL.glLightfv(GL.GL_LIGHT0, GL.GL_COLOR, new float[] {1f,1f,1f});
			//GL.glLightfv(GL.GL_LIGHT0, GL.GL_POSITION, pos);

			//GL.glLightf(GL.GL_LIGHT0, GL.GL_SPOT_CUTOFF, 180f);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see ui.MyCanvas#doLoadTextures()
	 */
	@Override
	protected void doLoadTextures()
	{
		// loadTeexture("lt512.png", IDX_GROUND_TEXTURE);
		//loadTeexture("eu.png", IDX_GROUND_TEXTURE);
		//loadTeexture("lt512.png", IDX_GROUND_TEXTURE);
		loadTeexture("eu_small.png", IDX_GROUND_TEXTURE);
	}

	/* (non-Javadoc)
	 * @see ui.MyCanvas#doLoadShapes()
	 */
	@Override
	protected void doLoadShapes()
	{
		brickShape = addShape("enemy.obj");
		wallShape = addShape("wall.obj");
		//platformShape = addShape("platform.obj");
		platformShape = addShape("raketeBlend.obj");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see ui.MyCanvas#doInitSceneGraph()
	 */
	@Override
	protected void doInitSceneGraph()
	{
		game.init(this);

		Glyph g = new Glyph(brickShape);
		// addGlyph(g);

		for (int r = 0; r != game.ROWS; ++r)
			for (int c = 0; c != game.COLS; ++c)
			{
				//dbg(" c " + c + " r " + r);
				Box b = game.field[r][c];
				if (b != null)
					initBox(b);
			}
	}
	
	protected void initBox(Box b)
	{
		Point3f color = null;
		
		if (b.glyph == null)
		{
			Shape s = null;
			switch (b.type)
			{
			case Box.BRICK:
				s = brickShape;
				color = b.color;
				break;
			case Box.WALL:
				s = wallShape;
				color = new Point3f(0.5f, 0.5f, .5f);
				break;
			case Box.LAVA:
				s = lavaShape;
				color = new Point3f(0, 0, 1f);
				break;

			default:
				break;
			}

			Glyph g = new Glyph(s);
			float x = b.col * Game.WIDTH + Game.WIDTH / 2f;
			float z = b.row * Game.HEIGHT + Game.HEIGHT / 2f;
			g.pos = new Point3f(x, 0f, z);
			g.color = color;
			g.scale = new Point3f(Game.WIDTH, 1f, Game.HEIGHT);
			
			b.glyph = g;

			addGlyph(g);
		}
	}
}






















