package ui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

import javax.vecmath.Point3f;

public class OBJReader
{
	public static final String SER_PREFIX = "SERIALIZED_";
	public static final String SER_EXT = ".ser";
	
	public ArrayList<Point3f> vertices;

	public ArrayList<Point3f> normals;

	public ArrayList<Polygon> polys;

	public boolean wireFrame = false;

	public boolean mtlincluded = false;

	public int mtlnum = -1; // mtlnum is initially -1 and it keeps the current
							// index of

	// the mtl.

	public OBJReader()
	{
		vertices = new ArrayList<Point3f>();
		normals = new ArrayList<Point3f>();
		polys = new ArrayList<Polygon>();
		// textures = new Vector();
		// mtlinfo = new Vector();
		// mtlincluded = mtlexists;
	}
	
	void loadSerFile(File file) throws IOException, ClassNotFoundException
	{
		FileInputStream is = new FileInputStream(file);
		ObjectInputStream ois = new ObjectInputStream(is);
		
		SerializeGlyph so = (SerializeGlyph)ois.readObject();
		
		this.vertices = so.vertices;
		this.normals = so.normals;
		this.polys = so.polys;
		
		ois.close();
		is.close();
		
	}
	
	void saveSerFile(File file) throws IOException
	{
		FileOutputStream os = new FileOutputStream(file);
		ObjectOutputStream oos = new ObjectOutputStream(os);
		
		SerializeGlyph so = new SerializeGlyph();
		so.vertices = this.vertices;
		so.normals = this.normals;
		so.polys = this.polys;
		
		oos.writeObject(so);
		oos.flush();
		os.flush();
	}
	
	void readFile(String fname)
	{
		try
		{
			File serFile = new File(SER_PREFIX + fname + SER_EXT);
			
			if (serFile.exists())
			{
				loadSerFile(serFile);
				return;
			}
			
			FileReader fr = new FileReader(new File(fname));
			BufferedReader input = new BufferedReader(fr);
			try
			{
				String newLine = null;
				while ((newLine = input.readLine()) != null)
				{
					int ind = newLine.indexOf("vn ");
					if (ind != -1)
					{
						readNormal(newLine);
						continue;
					}

					ind = newLine.indexOf("v ");
					if (ind != -1)
					{
						readVertex(newLine);
						continue;
					}

					ind = newLine.indexOf("f ");
					if (ind != -1)
					{
						readPolygon(newLine);
						continue;
					}

					ind = newLine.indexOf("vt ");
					if (ind != -1)
					{
						readTexture(newLine);
						continue;
					}

					ind = newLine.indexOf("usemtl ");
					if (ind != -1)
					{
						readMTLInfo(newLine);
						continue;
					}
				}
				
				normalize();
				
				// cache it into serialized file
				saveSerFile(serFile);
			}
			finally
			{
				input.close();
				fr.close();
			}
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
			System.out.println("got ex " + ex);
			System.exit(0);
		}
	}
	
	public void normalize()
	{
		// produce shape of unit-size

		Point3f min = new Point3f(1000000f,1000000f, 1000000f);
		Point3f max = new Point3f(-1000000f,-1000000f,-1000000f);
		
		
		for(int i = 0; i != vertices.size(); ++i)
		{
			Point3f v = vertices.get(i);
			
			min.x = Math.min(v.x, min.x);
			min.y = Math.min(v.y, min.y);
			min.z = Math.min(v.z, min.z);

			max.x = Math.max(v.x, max.x);
			max.y = Math.max(v.y, max.y);
			max.z = Math.max(v.z, max.z);
		}
		
		Point3f dim = new Point3f();
		dim.x = max.x - min.x;
		dim.y = max.y - min.y;
		dim.z = max.z - min.z;
		
		Point3f scale = new Point3f();
		scale.x = 1f/dim.x;
		scale.y = 1f/dim.y;
		scale.z = 1f/dim.z;
		
		
		dbg("min" + min);
		dbg("max " + max);
		dbg("dim" + dim);
		dbg("scl" + scale + "\n");
		
		for(Point3f v : vertices)
		{
			v.x = v.x*scale.x;
			v.y = v.y*scale.y;
			v.z = v.z*scale.z;
		}
		
	}

	public String[] splitTokens(String line, String sep)
	{
		List<String> toks = new ArrayList<String>();
		StringTokenizer tk = new StringTokenizer(line, sep, false);
		while (tk.hasMoreTokens())
			toks.add(tk.nextToken());

		String[] arr = new String[toks.size()];
		for (int i = 0; i != arr.length; ++i)
			arr[i] = toks.get(i);

		return arr;
	}

	void readVertex(String newLine)
	{
		String pieces[] = splitTokens(newLine, " ");
		Point3f vec = new Point3f(Float.valueOf(pieces[1]), Float.valueOf(pieces[2]),
				Float.valueOf(pieces[3]));
		vertices.add(vec);
	}

	void readNormal(String newLine)
	{
		String pieces[] = splitTokens(newLine, " ");
		Point3f vec = new Point3f(Float.valueOf(pieces[1]), Float.valueOf(pieces[2]),
				Float.valueOf(pieces[3]));
		normals.add(vec);
	}

	void readTexture(String newLine)
	{
		String pieces[] = splitTokens(newLine, " ");
		// Vec3 tex = new Vec3(float(pieces[1]), float(pieces[2]));
		// textures.addElement(tex);
	}

	void readPolygon(String newLine)
	{
		String pieces[] = splitTokens(newLine, " ");
		Polygon poly = new Polygon(pieces.length - 1);
		//dbg("loading polygon #" + (polys.size()+1));

		for (int i = 1; i < pieces.length; i++)
		{
			//dbg("line " + newLine);
			String smallerPieces[] = splitTokens(pieces[i], "//");
			int idx = i - 1;
			int vertIdx = Integer.valueOf(smallerPieces[0]);
			int normIdx = Integer.valueOf(smallerPieces[1]);

			if (vertIdx > this.vertices.size() || normIdx > this.normals.size())
			{
				dbg("INVALID INDEX on LINE: " + newLine);
				return;
			}
			poly.verts[idx] = this.vertices.get(vertIdx-1);
			poly.norms[idx] = this.normals.get(normIdx-1);
		}
		polys.add(poly);
	}

	void readMTLInfo(String newLine)
	{
		/*
		 * String pieces[] = splitTokens(newLine, " "); int mtlsize =
		 * mtlinfo.size(); int i = 0; boolean mtlfound = false; while(i <
		 * mtlsize && !mtlfound){ MTLInfo mtl = (MTLInfo) mtlinfo.elementAt(i);
		 * if(pieces[1].equals(mtl.name)) { mtlfound = true; mtlnum = i; } i++;
		 * }
		 */
	}
	
	private static void dbg(String msg)
	{
		System.out.println("DBG:: " + msg);
	}
}
