package ui;

public class Rect
{
	public float x;
	public float z;
	public float width;
	public float height;
	
	public boolean hasPoint(float px, float pz)
	{
		return (px >= x && px <= x + width) && (pz >= z && pz <= z + height);
	}
	
	boolean hitsVertically(float px, float pz)
	{
		float dx1 = px - x;
		float dx2 = (x + width) - px;
		float dx = Math.min(Math.abs(dx1), Math.abs(dx2));
		
		float dz1 = pz - z;
		float dz2 = (z + height) - pz;
		float dz = Math.min(Math.abs(dz1), Math.abs(dz2));
		
		return dz < dx;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString()
	{
		return "[Rect: x=" + x + ", z=" + z + ", w=" + width + ", h=" + height + "]";
	}
}
