package ui;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.swt.opengl.GL;

public class Shape
{
	public int dispListIndex = -1;

	public List<Polygon> polys = new ArrayList<Polygon>();

	public Shape()
	{
	}

	public Shape(List<Polygon> polys)
	{
		this.polys = polys;
	}

	public Shape(List<Polygon> polys, int dispListIndex)
	{
		this.polys = polys;
		this.dispListIndex = dispListIndex;
	}

	public void render()
	{
		GL.glBegin(GL.GL_QUADS);
		boolean curQuads = true;

		int i = 0;
		for (Polygon p : polys)
		{
			// dbg("drawing " +i);

			if (p.verts.length == 4)
			{
				if (!curQuads)
				{
					GL.glEnd();
					GL.glBegin(GL.GL_QUADS);
				}
				curQuads = true;
				
				GL.glNormal3d(p.norms[0].x, p.norms[0].y, p.norms[0].z);
				GL.glVertex3d(p.verts[0].x, p.verts[0].y, p.verts[0].z);

				GL.glNormal3d(p.norms[1].x, p.norms[1].y, p.norms[1].z);
				GL.glVertex3d(p.verts[1].x, p.verts[1].y, p.verts[1].z);

				GL.glNormal3d(p.norms[2].x, p.norms[2].y, p.norms[2].z);
				GL.glVertex3d(p.verts[2].x, p.verts[2].y, p.verts[2].z);

				GL.glNormal3d(p.norms[3].x, p.norms[3].y, p.norms[3].z);
				GL.glVertex3d(p.verts[3].x, p.verts[3].y, p.verts[3].z);
			}
			else
			{
				if (curQuads)
				{
					GL.glEnd();
					GL.glBegin(GL.GL_TRIANGLES);
				}
				curQuads = false;

				GL.glNormal3d(p.norms[0].x, p.norms[0].y, p.norms[0].z);
				GL.glVertex3d(p.verts[0].x, p.verts[0].y, p.verts[0].z);

				GL.glNormal3d(p.norms[1].x, p.norms[1].y, p.norms[1].z);
				GL.glVertex3d(p.verts[1].x, p.verts[1].y, p.verts[1].z);

				GL.glNormal3d(p.norms[2].x, p.norms[2].y, p.norms[2].z);
				GL.glVertex3d(p.verts[2].x, p.verts[2].y, p.verts[2].z);
			}

			++i;
		}

		GL.glEnd();
	}
	
	private static void dbg(String msg)
	{
		System.out.println("DBG:: " + msg);
	}
}
