// Decompiled by Jad v1.5.8g. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.kpdus.com/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   SplitContainer.java

package ui;

import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;
import util.log;

public class SplitContainer extends Composite
    implements PaintListener, MouseListener, MouseMoveListener, ControlListener
{

    public SplitContainer(Composite parent, int style)
    {
        super(parent, style);
        mDefaultBg = new Color(Display.getDefault(), 224, 224, 224);
        mMaxBg = new Color(Display.getDefault(), 0, 0, 0);
        mCenter = null;
        mXPad = 4;
        mYPad = 4;
        mPad = 2;
        mDragStarted = false;
        mSplitOrigin = new Point(0, 0);
        mMaximized = false;
        mActiveIndex = 0;
        mBgCol = mDefaultBg;
        mLastHeight = 0;
        addMouseListener(this);
        addMouseMoveListener(this);
        addPaintListener(this);
        addControlListener(this);
        setBackground(mDefaultBg);
    }

    public void setup(Control c[])
    {
        mTop = c[0];
        mLeft = c[1];
        mRight = c[2];
        mLst = new Control[3];
        mLst[0] = c[0];
        mLst[1] = c[1];
        mLst[2] = c[2];
    }

    public void setup(Control top, Control left, Control right)
    {
        mTop = top;
        mLeft = left;
        mRight = right;
        mLst = new Control[3];
        mLst[0] = top;
        mLst[1] = left;
        mLst[2] = right;
    }

    public void setFocusedChild(Control c)
    {
        for(int i = 0; i != mLst.length; i++)
            if(mLst[i] == c.getParent())
                mActiveIndex = i;

    }

    public void activateNext()
    {
        if(mActiveIndex == mLst.length - 1)
            mActiveIndex = 0;
        else
            mActiveIndex++;
        updateDecorations();
        setActive(mActiveIndex);
    }

    public void setState(boolean max)
    {
        if(mMaximized == max)
            return;
        if(max)
            mBgCol = mMaxBg;
        else
            mBgCol = mDefaultBg;
        mMaximized = max;
        layout();
        updateStates();
    }

    public void toggleState()
    {
        setState(!mMaximized);
    }

    public void setActive(int idx)
    {
        log.d("activating " + idx);
        mActiveIndex = idx;
        updateDecorations();
        layout();
        updateStates();
    }

    public void doSetFocus(Control w)
    {
        w.setFocus();
    }

    public void updateStates()
    {
        log.d("requesting focus for " + mLst[mActiveIndex]);
        doSetFocus(mLst[mActiveIndex]);
        for(int i = 0; i != mLst.length; i++)
        {
            Control c = mLst[i];
            if(i != mActiveIndex)
            {
                if(mMaximized && c.isVisible())
                    c.setVisible(false);
                if(!mMaximized && !c.isVisible())
                    c.setVisible(true);
            } else
            {
                log.d("Requesting focus on " + i + "th " + c);
                requestDeepestFocus(c);
                if(!c.isVisible())
                    c.setVisible(true);
            }
        }

    }

    public void requestDeepestFocus(Control control)
    {
    }

    public void setCenter(Point center)
    {
        mCenter.x = center.x;
        mCenter.y = center.y;
        layout();
    }

    public void doLayout()
    {
        Rectangle r = getClientArea();
        int w = r.width;
        int h = r.height;
        mLastHeight = h;
        if(h <= 0)
            return;
        if(mCenter == null)
            mCenter = new Point(w / 2, h / 2);
        if(mLst == null)
            return;
        Point c = mCenter;
        if(mMaximized)
        {
            Control cp = mLst[mActiveIndex];
            cp.setLocation(0, 0);
            cp.setSize(w, h);
            redraw();
            cp.redraw();
            log.d("maximizing " + cp);
        } else
        {
            mTop.setBounds(mPad, mPad, w - mPad * 2, c.y - mPad - mYPad);
            mLeft.setBounds(mPad, c.y + mYPad, c.x - mPad - mXPad, h - c.y - mYPad - mPad);
            mRight.setBounds(c.x + mXPad, c.y + mYPad, w - c.x - mPad - mXPad, h - c.y - mYPad - mPad);
        }
        for(int i = 0; i != mLst.length; i++)
            if(mLst[i] instanceof Composite)
                ((Composite)mLst[i]).layout();

    }

    public void updateDecorations()
    {
        for(int i = 0; i != mLst.length; i++)
        {
            Control control = mLst[i];
        }

    }

    public void setChildSize(Control c, int x, int y, int w, int h)
    {
        c.setBounds(x + mXPad, y + mYPad, w - mXPad * 2, h - mYPad * 2);
    }

    public void controlMoved(ControlEvent controlevent)
    {
    }

    public void controlResized(ControlEvent e)
    {
        Rectangle r = getClientArea();
        if(mCenter != null)
            mCenter.y += r.height - mLastHeight;
        doLayout();
    }

    public void mouseMove(MouseEvent e)
    {
        if(!mDragStarted)
            return;
        Point so = mSplitOrigin;
        int dx = e.x - mDragOrigin.x;
        int dy = e.y - mDragOrigin.y;
        Rectangle r = getClientArea();
        int w = r.width;
        int h = r.height;
        if(so.x + dx > w)
            dx = w - so.x;
        if(so.y + dy > h)
            dy = h - so.y;
        if(so.x + dx < 0)
            dx = -so.x;
        if(so.y + dy < 0)
            dy = -so.y;
        mCenter.x = mSplitOrigin.x + dx;
        mCenter.y = mSplitOrigin.y + dy;
        for(int i = 0; i != mLst.length; i++)
            mLst[i].setRedraw(true);

        setRedraw(true);
        showAll(false);
        doLayout();
        showAll(true);
    }

    public void showAll(boolean show)
    {
        if(!show)
        {
            for(int i = 0; i != mLst.length; i++)
                mLst[i].setVisible(show);

            setVisible(show);
        } else
        {
            setVisible(show);
            for(int i = 0; i != mLst.length; i++)
                mLst[i].setVisible(show);

        }
    }

    public void paintControl(PaintEvent e)
    {
        GC g = e.gc;
        Rectangle r = getClientArea();
        int w = r.width;
        int h = r.height;
        paintComponent(g);
    }

    public void mouseDoubleClick(MouseEvent mouseevent)
    {
    }

    public void mouseDown(MouseEvent e)
    {
        mDragOrigin = new Point(e.x, e.y);
        mSplitOrigin.x = mCenter.x;
        mSplitOrigin.y = mCenter.y;
        mDragStarted = true;
    }

    public void mouseUp(MouseEvent e)
    {
        mouseMove(e);
        mDragStarted = false;
    }

    protected void paintComponent(GC g)
    {
        Rectangle r = getClientArea();
        if(mMaximized)
        {
            return;
        } else
        {
            int w = r.width;
            int h = r.height;
            g.setBackground(mBgCol);
            g.fillRectangle(0, 0, w, h);
            h--;
            w--;
            paintPatter(g, new Rectangle(0, mCenter.y - mYPad, w, mYPad * 2));
            paintPatter(g, new Rectangle(mCenter.x - mXPad, mCenter.y + mYPad, mXPad * 2, h - mCenter.y - mYPad));
            paintDiamond(g, mCenter.x, mCenter.y);
            return;
        }
    }

    public void paintDiamond(GC g, int x, int y)
    {
        g.setForeground(mDiamCol);
        int gap = 0;
        y -= 2;
        x--;
        for(int i = 0; i != 4; i++)
        {
            g.drawLine(x - gap, y, x + gap, y);
            y++;
            gap++;
        }

        for(int i = 0; i != 4; i++)
        {
            gap--;
            g.drawLine(x - gap, y, x + gap, y);
            y++;
        }

    }

    public void paintPatter(GC g, Rectangle r)
    {
        int w = r.width / 4;
        int h = r.height / 4;
        if(w < 1 || h < 1)
            return;
        for(int i = 0; i != w; i++)
        {
            for(int k = 0; k != h; k++)
            {
                int x = r.x + i * 4;
                int y = r.y + k * 4;
                g.setForeground(cGray);
                g.drawLine(x + 0, y + 0, x, y);
                g.drawLine(x + 2, y + 2, x + 2, y + 2);
                g.setForeground(cWhite);
                g.drawLine(x + 1, y + 1, x + 1, y + 1);
                g.drawLine(x + 3, y + 3, x + 3, y + 3);
            }

        }

    }

    protected Color mDefaultBg;
    protected Color mMaxBg;
    protected Point mCenter;
    protected int mXPad;
    protected int mYPad;
    protected int mPad;
    protected Control mTop;
    protected Control mLeft;
    protected Control mRight;
    protected Control mLst[];
    protected Point mDragOrigin;
    protected boolean mDragStarted;
    protected Point mSplitOrigin;
    protected boolean mMaximized;
    protected int mActiveIndex;
    protected Color mBgCol;
    protected int mLastHeight;
    public static final Color mDiamCol = new Color(Display.getDefault(), 128, 128, 255);
    public static final Color cGray = new Color(Display.getDefault(), 128, 128, 128);
    public static final Color cWhite = new Color(Display.getDefault(), 255, 255, 255);

}
