// Decompiled by Jad v1.5.8g. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.kpdus.com/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   TriNode.java

package ui;

import java.io.PrintStream;
import java.util.ArrayList;
import javax.vecmath.*;

public class TriNode
{

    public int getChildIndex(TriNode child)
    {
        for(int i = 0; i != clst.length; i++)
            if(clst[i] == child)
                return i;

        return -1;
    }

    public int countParents()
    {
        TriNode p = parent;
        int n;
        for(n = 1; p != null; n++)
            p = p.parent;

        return n;
    }

    public void dbg(String msg)
    {
        System.out.println(msg);
    }

    public TriNode()
    {
        id = -1;
        pts = new Point2f[3];
        spts = new Point3f[3];
        vec = new Vector3f();
        mid = new Point3f();
        clst = null;
        parent = null;
        normal = new Vector3f();
        for(int i = 0; i != pts.length; i++)
            pts[i] = new Point2f();

        for(int i = 0; i != spts.length; i++)
            spts[i] = new Point3f();

    }

    public void findLeafs(ArrayList toLst)
    {
        if(isLeaf())
            toLst.add(this);
        else
        if(clst != null)
        {
            for(int i = 0; i != clst.length; i++)
                clst[i].findLeafs(toLst);

        }
    }

    public void rescale2d(int imgWidth, int imgHeight)
    {
        ArrayList leafs = new ArrayList();
        findLeafs(leafs);
        float maxX = -1000F;
        float maxY = -1000F;
        float minX = 1000F;
        float minY = 1000F;
        for(int i = 0; i != leafs.size(); i++)
        {
            TriNode t = (TriNode)leafs.get(i);
            for(int k = 0; k != t.pts.length; k++)
            {
                Point2f p = t.pts[k];
                if(((Tuple2f) (p)).x > maxX)
                    maxX = ((Tuple2f) (p)).x;
                if(((Tuple2f) (p)).y > maxY)
                    maxY = ((Tuple2f) (p)).y;
                if(((Tuple2f) (p)).x < minX)
                    minX = ((Tuple2f) (p)).x;
                if(((Tuple2f) (p)).y < minY)
                    minY = ((Tuple2f) (p)).y;
            }

        }

    }

    public void createChildren2d(int level)
    {
        Point2f a = midpoint(pts[0], pts[2]);
        Point2f b = midpoint(pts[0], pts[1]);
        Point2f c = midpoint(pts[1], pts[2]);
        int i0 = 0;
        int i1 = 1;
        int i2 = 2;
        TriNode n = getChild(0);
        n.pts[i0].set(pts[0]);
        n.pts[i1].set(b);
        n.pts[i2].set(a);
        n = getChild(1);
        n.pts[i0].set(b);
        n.pts[i1].set(pts[1]);
        n.pts[i2].set(c);
        n = getChild(2);
        n.pts[i0].set(a);
        n.pts[i1].set(b);
        n.pts[i2].set(c);
        n = getChild(3);
        n.pts[i0].set(a);
        n.pts[i1].set(c);
        n.pts[i2].set(pts[2]);
        if(level > 0)
        {
            for(int i = 0; i != clst.length; i++)
                clst[i].createChildren2d(level - 1);

        }
    }

    public void calcCenterVec()
    {
        Point3f a = midpoint(spts[0], spts[2]);
        Point3f b = midpoint(a, spts[1]);
        vec.set(b);
        mid.set(vec);
        Vector3f ab = new Vector3f(((Tuple3f) (spts[1])).x - ((Tuple3f) (spts[0])).x, ((Tuple3f) (spts[1])).y - ((Tuple3f) (spts[0])).y, ((Tuple3f) (spts[1])).z - ((Tuple3f) (spts[0])).z);
        float len = ab.length();
        float len1 = (new Vector3f(mid)).length();
        mid.scale(len / len1);
        Point3f p1 = spts[2];
        Point3f p2 = spts[1];
        Point3f p3 = spts[0];
        Vector3f v1 = new Vector3f(((Tuple3f) (p2)).x - ((Tuple3f) (p1)).x, ((Tuple3f) (p2)).y - ((Tuple3f) (p1)).y, ((Tuple3f) (p2)).z - ((Tuple3f) (p1)).z);
        Vector3f v2 = new Vector3f(((Tuple3f) (p3)).x - ((Tuple3f) (p1)).x, ((Tuple3f) (p3)).y - ((Tuple3f) (p1)).y, ((Tuple3f) (p3)).z - ((Tuple3f) (p1)).z);
        normal.cross(v1, v2);
        normal.normalize();
    }

    public void createChildren3d(int level)
    {
        Point3f a = midpoint(spts[0], spts[2]);
        Point3f b = midpoint(spts[0], spts[1]);
        Point3f c = midpoint(spts[1], spts[2]);
        float lenAB = len(a, b);
        float lenBC = len(b, c);
        float lenCA = len(c, a);
        float lenA0 = len(spts[0], a);
        float lenB0 = len(spts[0], b);
        int i0 = 0;
        int i1 = 1;
        int i2 = 2;
        TriNode n = getChild(0);
        n.spts[i0].set(spts[0]);
        n.spts[i1].set(b);
        n.spts[i2].set(a);
        n = getChild(1);
        n.spts[i0].set(b);
        n.spts[i1].set(spts[1]);
        n.spts[i2].set(c);
        n = getChild(2);
        n.spts[i0].set(a);
        n.spts[i1].set(b);
        n.spts[i2].set(c);
        n = getChild(3);
        n.spts[i0].set(a);
        n.spts[i1].set(c);
        n.spts[i2].set(spts[2]);
        for(int i = 0; i != clst.length; i++)
            clst[i].calcCenterVec();

        if(level > 0)
        {
            for(int i = 0; i != clst.length; i++)
                clst[i].createChildren3d(level - 1);

        }
    }

    public int calcLeafs()
    {
        if(isLeaf())
            return 1;
        int cnt = 0;
        for(int i = 0; i != clst.length; i++)
            cnt += clst[i].calcLeafs();

        return cnt;
    }

    public void normalize3d()
    {
        if(clst != null)
        {
            for(int i = 0; i != clst.length; i++)
                clst[i].normalize3d();

        }
    }

    public void scalePt(Point3f p, float s)
    {
        p.x *= s;
        p.y *= s;
        p.z *= s;
    }

    public void initTetrahedron(int level, float scale)
    {
        clst = new TriNode[verts.length / 3];
        for(int i = 0; i != clst.length; i++)
        {
            clst[i] = new TriNode();
            clst[i].parent = this;
        }

        if(level > 0)
        {
            for(int i = 0; i != verts.length / 3; i++)
            {
                TriNode c = getChild(i);
                c.spts[0].set(verts[i * 3 + 0]);
                c.spts[1].set(verts[i * 3 + 1]);
                c.spts[2].set(verts[i * 3 + 2]);
                normalize2(c.spts[0]);
                normalize2(c.spts[1]);
                normalize2(c.spts[2]);
                c.calcCenterVec();
            }

        }
        if(--level > 0)
        {
            for(int i = 0; i != clst.length; i++)
                clst[i].createChildren3d(level - 1);

        }
        normalize3d();
    }

    protected Point3f midpoint(Point3f a, Point3f b)
    {
        Point3f mid = new Point3f();
        float mul = 0.5F;
        mid.x = (((Tuple3f) (a)).x + ((Tuple3f) (b)).x) * mul;
        mid.y = (((Tuple3f) (a)).y + ((Tuple3f) (b)).y) * mul;
        mid.z = (((Tuple3f) (a)).z + ((Tuple3f) (b)).z) * mul;
        normalize2(mid);
        return mid;
    }

    protected float len(Tuple3f t1, Tuple3f t2)
    {
        Vector3f v = new Vector3f();
        v.sub(t1, t2);
        return len(((Tuple3f) (v)));
    }

    protected float len(Tuple3f t)
    {
        return (float)Math.sqrt(t.x * t.x + t.y * t.y + t.z * t.z);
    }

    protected void normalize2(Point3f p)
    {
        float mag = ((Tuple3f) (p)).x * ((Tuple3f) (p)).x + ((Tuple3f) (p)).y * ((Tuple3f) (p)).y + ((Tuple3f) (p)).z * ((Tuple3f) (p)).z;
        if(mag != 0.0F)
        {
            mag = (float)(1.0D / Math.sqrt(mag));
            p.x *= mag;
            p.y *= mag;
            p.z *= mag;
        }
    }

    protected Point2f midpoint(Point2f a, Point2f b)
    {
        Point2f mid = new Point2f();
        mid.x = (((Tuple2f) (a)).x + ((Tuple2f) (b)).x) * 0.5F;
        mid.y = (((Tuple2f) (a)).y + ((Tuple2f) (b)).y) * 0.5F;
        return mid;
    }

    public TriNode getChild(int idx)
    {
        if(clst == null)
        {
            clst = new TriNode[4];
            for(int i = 0; i != clst.length; i++)
            {
                clst[i] = new TriNode();
                clst[i].parent = this;
            }

        }
        return clst[idx];
    }

    public boolean isLeaf()
    {
        return clst == null;
    }

    public int getVertexIndex(Point3f vtx)
    {
        for(int i = 0; i != 3; i++)
            if(spts[i].equals(vtx))
                return i;

        return -1;
    }

    private static final float sqrt3;
    private static final float sqrt3_3;
    private static final float sqrt24_3;
    private static final float ycenter;
    private static final float zcenter;
    private static final Point3f p1;
    private static final Point3f p2;
    private static final Point3f p3;
    private static final Point3f p4;
    private static final Point3f pmm;
    private static final Point3f mmp;
    private static final Point3f mpm;
    private static final Point3f ppp;
    private static final float CWIDTH = 1F;
    private static final float CHEIGHT = (float)Math.sqrt(0.75D);
    private static final int DEFAULT_LEVEL = 1;
    public static final float tau = 0.8506508F;
    public static final float one = 0.5257311F;
    public static final Point3f ZA;
    public static final Point3f ZB;
    public static final Point3f ZC;
    public static final Point3f ZD;
    public static final Point3f YA;
    public static final Point3f YB;
    public static final Point3f YC;
    public static final Point3f YD;
    public static final Point3f XA;
    public static final Point3f XB;
    public static final Point3f XC;
    public static final Point3f XD;
    public static final Point3f verts[];
    public int id;
    public Point2f pts[];
    public Point3f spts[];
    public Vector3f vec;
    public Point3f mid;
    public TriNode clst[];
    public TriNode parent;
    public float r;
    public float g;
    public float b;
    public float rX;
    public float rY;
    public float rZ;
    public float mov;
    public Vector3f normal;

    static 
    {
        sqrt3 = (float)Math.sqrt(3D);
        sqrt3_3 = sqrt3 / 3F;
        sqrt24_3 = (float)Math.sqrt(24D) / 3F;
        ycenter = 0.5F * sqrt24_3;
        zcenter = -sqrt3_3;
        p1 = new Point3f(-1F, -ycenter, -zcenter);
        p2 = new Point3f(1.0F, -ycenter, -zcenter);
        p3 = new Point3f(0.0F, -ycenter, -sqrt3 - zcenter);
        p4 = new Point3f(0.0F, sqrt24_3 - ycenter, 0.0F);
        pmm = new Point3f(sqrt3, sqrt3, sqrt3);
        mmp = new Point3f(-sqrt3, -sqrt3, sqrt3);
        mpm = new Point3f(-sqrt3, sqrt3, -sqrt3);
        ppp = new Point3f(sqrt3, -sqrt3, -sqrt3);
        ZA = new Point3f(0.8506508F, 0.5257311F, 0.0F);
        ZB = new Point3f(-0.8506508F, 0.5257311F, 0.0F);
        ZC = new Point3f(-0.8506508F, -0.5257311F, 0.0F);
        ZD = new Point3f(0.8506508F, -0.5257311F, 0.0F);
        YA = new Point3f(0.5257311F, 0.0F, 0.8506508F);
        YB = new Point3f(0.5257311F, 0.0F, -0.8506508F);
        YC = new Point3f(-0.5257311F, 0.0F, -0.8506508F);
        YD = new Point3f(-0.5257311F, 0.0F, 0.8506508F);
        XA = new Point3f(0.0F, 0.8506508F, 0.5257311F);
        XB = new Point3f(0.0F, -0.8506508F, 0.5257311F);
        XC = new Point3f(0.0F, -0.8506508F, -0.5257311F);
        XD = new Point3f(0.0F, 0.8506508F, -0.5257311F);
        verts = (new Point3f[] {
            YA, XA, YD, YA, YD, XB, YB, YC, XD, YB, 
            XC, YC, ZA, YA, ZD, ZA, ZD, YB, ZC, YD, 
            ZB, ZC, ZB, YC, XA, ZA, XD, XA, XD, ZB, 
            XB, XC, ZD, XB, ZC, XC, XA, YA, ZA, XD, 
            ZA, YB, YA, XB, ZD, YB, ZD, XC, YD, XA, 
            ZB, YC, ZB, XD, YD, ZC, XB, YC, XC, ZC
        });
    }
}
