// Decompiled by Jad v1.5.8g. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.kpdus.com/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   Geom.java

package util;

import java.awt.Rectangle;
import javax.vecmath.*;

public class Geom
{

    public Geom()
    {
    }

    public static float get_true_arctan(float dx, float dy)
    {
        if(dx == 0.0F && dy >= 0.0F)
            return 1.570796F;
        if(dx == 0.0F && dy <= 0.0F)
            return 4.712389F;
        if(dx >= 0.0F && dy == 0.0F)
            return 0.0F;
        if(dx <= 0.0F && dy == 0.0F)
            return 3.141593F;
        if(dx > 0.0F && dy > 0.0F)
            return (float)Math.atan(dy / dx);
        if(dx < 0.0F && dy > 0.0F)
            return (float)(3.1415926535897931D + Math.atan(dy / dx));
        if(dx < 0.0F && dy < 0.0F)
            return (float)(3.1415926535897931D + Math.atan(dy / dx));
        if(dx > 0.0F && dy < 0.0F)
            return (float)(6.2831853071795862D + Math.atan(dy / dx));
        else
            return 0.0F;
    }

    public static Point3f getMidPoint(Point3f p1, Point3f p2)
    {
        return new Point3f((((Tuple3f) (p1)).x + ((Tuple3f) (p2)).x) / 2.0F, (((Tuple3f) (p1)).y + ((Tuple3f) (p2)).y) / 2.0F, (((Tuple3f) (p1)).z + ((Tuple3f) (p2)).z) / 2.0F);
    }

    public static float getSlope(Point3f a1, Point3f a2)
    {
        return (((Tuple3f) (a2)).y - ((Tuple3f) (a1)).y) / (((Tuple3f) (a2)).x - ((Tuple3f) (a1)).x);
    }

    public static float getAngle(Vector3f v)
    {
        return get_true_arctan(((Tuple3f) (v)).x, ((Tuple3f) (v)).y);
    }

    public static float getAngle(Point3f a1, Point3f a2)
    {
        float dx = ((Tuple3f) (a2)).x - ((Tuple3f) (a1)).x;
        float dy = ((Tuple3f) (a2)).y - ((Tuple3f) (a1)).y;
        return get_true_arctan(dx, dy);
    }

    public static float vectorLength(Point3f a1, Point3f a2)
    {
        float dx = ((Tuple3f) (a1)).x - ((Tuple3f) (a2)).x;
        float dy = ((Tuple3f) (a1)).y - ((Tuple3f) (a2)).y;
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    public static void rotateAround(Point3f origin, Point3f point, float angle)
    {
        float dx = ((Tuple3f) (point)).x - ((Tuple3f) (origin)).x;
        float dy = ((Tuple3f) (point)).y - ((Tuple3f) (origin)).y;
        float ang = get_true_arctan(dx, dy);
        ang += angle;
        double len = Math.sqrt(dx * dx + dy * dy);
        point.x = ((Tuple3f) (origin)).x + (float)(len * Math.cos(ang));
        point.y = ((Tuple3f) (origin)).y + (float)(len * Math.sin(ang));
    }

    public static boolean isParallel(Point3f a1, Point3f a2, Point3f b1, Point3f b2, float epsilon)
    {
        float k = getSlope(a1, a2);
        float l = getSlope(b1, b2);
        return Math.abs(k - l) < epsilon;
    }

    public static void getIntersection(Point3f a1, Point3f a2, Point3f b1, Point3f b2, Point3f pnt)
    {
        float k = getSlope(a1, a2);
        float l = getSlope(b1, b2);
        pnt.x = 0.0F;
        pnt.y = 0.0F;
        float k_l = k - l;
        float a = ((Tuple3f) (a1)).y - k * ((Tuple3f) (a1)).x;
        float b = ((Tuple3f) (b1)).y - l * ((Tuple3f) (b1)).x;
        if(((Tuple3f) (a1)).x == ((Tuple3f) (a2)).x && ((Tuple3f) (b1)).x == ((Tuple3f) (b2)).x)
            return;
        if(((Tuple3f) (a1)).x == ((Tuple3f) (a2)).x)
        {
            pnt.x = ((Tuple3f) (a1)).x;
            pnt.y = l * ((Tuple3f) (a1)).x + b;
        } else
        if(((Tuple3f) (b1)).x == ((Tuple3f) (b2)).x)
        {
            pnt.x = ((Tuple3f) (b1)).x;
            pnt.y = k * ((Tuple3f) (b1)).x + a;
        } else
        {
            if((double)k_l == 0.0D)
                return;
            float x = (b - a) / k_l;
            pnt.x = x;
            pnt.y = k * x + a;
        }
    }

    public static boolean contains(Point3f a1, Point3f a2, Point3f point)
    {
        if(((Tuple3f) (a1)).x == ((Tuple3f) (point)).x && ((Tuple3f) (a1)).y == ((Tuple3f) (point)).y || ((Tuple3f) (a2)).x == ((Tuple3f) (point)).x && ((Tuple3f) (a2)).y == ((Tuple3f) (point)).y)
            return true;
        float ab = vectorLength(point, a1);
        float bc = vectorLength(point, a2);
        float ac = vectorLength(a1, a2);
        float epsilon = 1.0F;
        return Math.abs((ab + bc) - ac) < epsilon;
    }

    public static Point3f getProjectionOntoLine(Point3f a1, Point3f a2, Point3f pt)
    {
        mTmpPoint.x = ((Tuple3f) (pt)).x;
        mTmpPoint.y = ((Tuple3f) (pt)).y;
        mTmpPoint.x += 20F;
        rotateAround(pt, mTmpPoint, getAngle(a2, a1) + 1.570796F);
        getIntersection(a1, a2, pt, mTmpPoint, mTmpPoint0);
        return mTmpPoint0;
    }

    public static boolean liesNearBy(Point3f a1, Point3f a2, Point3f pt, float maxDist)
    {
        mTmpPoint.x = ((Tuple3f) (pt)).x;
        mTmpPoint.y = ((Tuple3f) (pt)).y;
        mTmpPoint.x += 20F;
        rotateAround(pt, mTmpPoint, getAngle(a2, a1) + 1.570796F);
        getIntersection(a1, a2, pt, mTmpPoint, mTmpPoint0);
        if(contains(a1, a2, mTmpPoint0))
            return vectorLength(pt, mTmpPoint0) <= maxDist;
        return vectorLength(a1, pt) <= maxDist || vectorLength(a2, pt) <= maxDist;
    }

    public static void accumulate(Rectangle dest, Rectangle src)
    {
        if(dest.width == -1)
        {
            dest.x = src.x;
            dest.y = src.y;
            dest.width = src.width;
            dest.height = src.height;
        } else
        {
            int tx = dest.x;
            int ty = dest.y;
            dest.x = Math.min(dest.x, src.x);
            dest.y = Math.min(dest.y, src.y);
            int botX = Math.max(tx + dest.width, src.x + src.width);
            int botY = Math.max(ty + dest.height, src.y + src.height);
            dest.width = botX - dest.x;
            dest.height = botY - dest.y;
        }
    }

    public static boolean pointsCoinside(Point3f p1, Point3f p2, float epsilon)
    {
        float d = Math.abs(((Tuple3f) (p1)).x - ((Tuple3f) (p2)).x);
        if(d > epsilon)
            return false;
        d = Math.abs(((Tuple3f) (p1)).y - ((Tuple3f) (p2)).y);
        return d <= epsilon;
    }

    public static Vector3f getProjection(Vector3f w, Vector3f v)
    {
        float lw = w.length();
        float lv = v.length();
        Vector3f uw = new Vector3f(((Tuple3f) (w)).x / lw, ((Tuple3f) (w)).y / lw, ((Tuple3f) (w)).z / lw);
        Vector3f uv = new Vector3f(((Tuple3f) (v)).x / lv, ((Tuple3f) (v)).y / lv, ((Tuple3f) (v)).z / lv);
        float cosPhi = uw.dot(uv);
        float lenKv = cosPhi * lw;
        Vector3f proj = new Vector3f(((Tuple3f) (uv)).x * lenKv, ((Tuple3f) (uv)).y * lenKv, ((Tuple3f) (uv)).z * lenKv);
        return proj;
    }

    public static Point3f mTmpPoint = new Point3f();
    public static Point3f mTmpPoint0 = new Point3f();
    public static Point3f mTmpPoint1 = new Point3f();
    public static Point3f mTmpPoint2 = new Point3f();
    public static Point3f mTmpPoint3 = new Point3f();
    public static Point3f mTmpPoint4 = new Point3f();

}
