var target:Transform;

function Update()
{
	transform.position.y = 120;
	//return;


	var m:Matrix4x4 = CalcOrtho(-camera.pixelWidth/2, camera.pixelWidth/2, -camera.pixelHeight/2, camera.pixelHeight/2, 0.3, 1000);
	Debug.Log(camera.projectionMatrix);
	var p:Plane;
	//var q:Quaternion = Quaternion.AngleAxis(30, Vector3(0,0,1));
	//t.Rotate(Vector3(0, 30, 0));
	p.SetNormalAndPosition(Vector3(1,0,0), Vector3.zero);
	camera.projectionMatrix = m;//CalculateObliqueMatrixOrtho(m, Vector4.Normalize(Vector4(0.7,0,1,0)));
	Debug.Log(m);
}

function LateUpdate () {	
	transform.position.x = target.position.x;
	transform.position.z = target.position.z - 128;
}

function CalcOrtho(left, right, bottom, top, zNear, zFar) : Matrix4x4 
{
	var m:Matrix4x4 = Matrix4x4.identity;

	var deltax = right - left;
	var deltay = top - bottom;
	var deltaz = zFar - zNear;

	m[0,0] = 2.0 / deltax;
	m[0,3] = -(right + left) / deltax;
	m[1,1] = 2.0 / deltay;
	m[1,3] = -(top + bottom) / deltay;
	m[2,2] = -2.0 / deltaz;
	m[2,3] = -(zFar + zNear) / deltaz;
	m[1,2] = m[1,2] + (1/deltay)*2.4;
//	m[2,1] = m[2,1] + 0.001;
//	m[2,1] = 0.003;
	return m;
}

function CalculateObliqueMatrixOrtho(projection:Matrix4x4 , clipPlane:Vector4):Matrix4x4
{
	var m:Matrix4x4 = projection;
    var q:Vector4  = m.inverse * new Vector4(
        Mathf.Sign(clipPlane.x),
        Mathf.Sign(clipPlane.y),
        1.0,
        1.0
    );
    var c:Vector4  = clipPlane * (2.0 / (Vector4.Dot (clipPlane, q)));
    // third row = clip plane - fourth row
    m[2] = c.x - m[3];
    m[6] = c.y - m[7];
    m[10] = c.z - m[11];
    m[14] = c.w - m[15];
    return m;
}