public var player:GameObject;
public var follower:GameObject;
public var walls:TerrainCollider;
public var bullet:GameObject;
public var superBullet:GameObject;

public var cursorType:int = 0;
public var cursorState:int = 0;
public var cursorCamera:Camera;

public var partsCollected:int = 0;

public var enemyDeathFX:GameObject;
public var enemyDeathFX2:GameObject;

public var playerHealth:GUITexture;
public var followerHealth:GUITexture;
public var wolfParts:GUITexture[];

// singleton
static var instance:GameManager;
function Awake()
{
	if(instance != null)
	{
		Destroy(gameObject);
		return;
	}
	instance = this;
}

private var visRay = [new Ray(), new Ray(), new Ray(), new Ray(), new Ray()];
function CheckOcclusion(go:GameObject):boolean
{
	if (!go.GetComponent(Renderer))
		return false;
		
	visRay[0].origin = go.transform.position;
	visRay[0].direction = Vector3(0, 0, -1);
	visRay[1].origin = go.transform.position - Vector3(go.renderer.bounds.extents.x * 0.65, 0, go.renderer.bounds.extents.z);
	visRay[1].direction = Vector3(0, 0, -1);
	visRay[2].origin = go.transform.position - Vector3(-go.renderer.bounds.extents.x * 0.65, 0, go.renderer.bounds.extents.z);
	visRay[2].direction = Vector3(0, 0, -1);
	
	var hit:RaycastHit;
	for (var q = 1; q < 1; ++q)
	{
		if (Physics.Raycast(visRay[q], hit, go.renderer.bounds.extents.y))
			return true;
	}

	return false;
}

function Update ()
{
	if ((partsCollected & 0x01) > 0)
		wolfParts[0].active = true;
	if ((partsCollected & 0x02) > 0)
		wolfParts[1].active = true;
	if ((partsCollected & 0x04) > 0)
		wolfParts[2].active = true;
	if ((partsCollected & 0x08) > 0)
		wolfParts[3].active = true;
	if ((partsCollected & 0x10) > 0)
		wolfParts[4].active = true;
	if ((partsCollected & 0x20) > 0)
		wolfParts[5].active = true;
	if (partsCollected == 63)
		Application.LoadLevel(3);
}

/*
public var life = 100;
private var score = 0;
function Damage(d:int)
{
	if (life > 0)
		life -= d;
}

function Score(s:int)
{
	score += s;
}

function OnGUI()
{
	GUI.Label(Rect(8,8,80,24), "Energy: " + life);
	GUI.Label(Rect(8,24,80,24), "Score: " + score);
}*/