using UnityEngine;
using System.Collections;

public class SetupTerrain : MonoBehaviour {
	
	//public TerrainData terrainData = null;
	public Texture2D sourceTexture = null;
	
	
	public Terrain terrain;
	// Use this for initialization
	void Start () {
		ReadRaw(terrain.terrainData, sourceTexture);
		//gameObject.AddComponent("TerrainCollider");
		//((TerrainCollider)gameObject.collider).terrainData = terrain.terrainData;
		//terrain.gameObject.active = false;
	}
	
	// Update is called once per frame
	void Update () {
	}
	
	protected void ReadRaw (TerrainData dst, Texture2D src)
	{
		// Read data
		Color[] data = src.GetPixels(0);
		int srcWidth = src.width;
		int srcHeight = src.height;
		
		dst.heightmapResolution = srcWidth;
		
		int heightmapWidth = dst.heightmapWidth;
		int heightmapHeight = dst.heightmapHeight;
		float[,] heights = new float[heightmapHeight, heightmapWidth];
		{
			for (int y=0;y<heightmapHeight;y++)	
			{
				for (int x=0;x<heightmapWidth;x++)
				{
					int index = Mathf.Clamp(x, 0, srcWidth - 1) + Mathf.Clamp(y, 0, srcHeight - 1) * srcWidth;
					float height = data[index].r * 0.07F;
					heights[y,x] = height;
				}
			}
		}
		dst.SetHeights (0, 0, heights);
	}
}
