private var charge = 0;
private var chargeDir:Vector3 = Vector3.zero;

function Update() {
	if (GameManager.instance.CheckOcclusion(gameObject))
		renderer.material.renderQueue = 2000;
	else
		renderer.material.renderQueue = 3000 + 10;
}

function FixedUpdate () {
	if (charge > 0)
	{
		--charge;
		rigidbody.AddForce(-chargeDir*30);
		if (rigidbody.velocity.magnitude > 50)
			rigidbody.drag += 1.0;

		return;
	}
	
	var d:Vector3 = transform.position - GameManager.instance.follower.transform.position;
	var d2:Vector3 = transform.position - GameManager.instance.player.transform.position;
	d.y = 0;
	d2.y = 0;
	
	if (d2.magnitude + 300 < d.magnitude)
		d = d2;
	
	rigidbody.drag = 0;
	if (d.magnitude < 70)
	{
		charge = 150;
		chargeDir = d;
		return;
	}
	else if (d.magnitude < 300)
	{
		d = Vector3.Normalize(d);
		rigidbody.AddForce(-d*10);
	}
	else
		rigidbody.drag += 0.5;
	
	if (Vector3.Dot(-d, Vector3.Normalize(rigidbody.velocity)) < 0.7)//Mathf.Cos((Mathf.PI/180)*70))
		rigidbody.drag += 1;
	
	if (rigidbody.velocity.magnitude > 10)
		rigidbody.drag += 0.5;
}
